/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import net.opengis.gml.v32.AbstractGeometry;
import net.opengis.gml.v32.Point;
import net.opengis.gml.v32.Polygon;
import org.vast.ogc.OGCRegistry;
import org.vast.ogc.gml.GMLUtils;
import org.vast.ows.OWSException;
import org.vast.ows.OWSLayerCapabilities;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.sps.SPSException;
import org.vast.ows.sps.SPSOfferingCapabilities;
import org.vast.ows.sps.SPSServiceCapabilities;
import org.vast.ows.swe.SWESCapabilitiesWriterV20;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SPSCapabilitiesWriterV20
extends SWESCapabilitiesWriterV20 {
    GMLUtils gmlUtils = new GMLUtils("3.2");

    @Override
    public Element buildXMLResponse(DOMHelper dom, OWSServiceCapabilities caps, String version) throws OWSException {
        dom.addUserPrefix("sps", OGCRegistry.getNamespaceURI((String)"SPS", (String)version));
        dom.addUserPrefix("swes", OGCRegistry.getNamespaceURI((String)"SWES", (String)"2.0"));
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        dom.addUserPrefix("xlink", OGCRegistry.getNamespaceURI((String)"XLINK"));
        Element capsElt = dom.createElement("sps:Capabilities");
        this.writeRootAttributes(dom, capsElt, caps, version);
        this.writeServiceIdentification(dom, capsElt, caps);
        this.writeServiceProvider(dom, capsElt, caps.getServiceProvider());
        this.writeOperationsMetadata(dom, capsElt, caps);
        this.writeContents(dom, capsElt, caps, version);
        return capsElt;
    }

    @Override
    protected void writeContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps, String version) throws OWSException {
        try {
            Element contentsElt = dom.addElement((Node)capsElt, "sps:contents/sps:SPSContents");
            SPSServiceCapabilities spsCaps = (SPSServiceCapabilities)serviceCaps;
            super.writeCommonContentsProperties(dom, contentsElt, serviceCaps);
            for (OWSLayerCapabilities oWSLayerCapabilities : serviceCaps.getLayers()) {
                Element offeringElt = dom.addElement((Node)contentsElt, "+swes:offering/sps:SensorOffering");
                SPSOfferingCapabilities offering = (SPSOfferingCapabilities)oWSLayerCapabilities;
                super.writeCommonOfferingProperties(dom, offeringElt, serviceCaps, offering);
                AbstractGeometry obsArea = offering.getObservableArea();
                if (obsArea == null) continue;
                Element geomElt = this.gmlUtils.writeGeometry(dom, obsArea);
                String path = "sps:observableArea/";
                if (obsArea instanceof Polygon) {
                    path = path + "sps:byPolygon";
                } else if (obsArea instanceof Point) {
                    path = path + "sps:byPoint";
                } else {
                    throw new SPSException("Invalid geometry for observedArea: " + obsArea.getClass().getSimpleName());
                }
                dom.addElement((Node)offeringElt, path).appendChild(geomElt);
            }
            double minStatusTime = spsCaps.getMinStatusTime();
            if (!Double.isNaN(minStatusTime)) {
                dom.setElementValue(contentsElt, "sps:minStatusTime", this.timeFormat.formatIsoPeriod(minStatusTime, 'D'));
            }
            for (String encoding : spsCaps.getSupportedEncodings()) {
                dom.setElementValue(contentsElt, "+sps:supportedEncoding", encoding);
            }
        }
        catch (XMLWriterException e) {
            throw new SPSException("Error while writing SPS capabilities", (Exception)((Object)e));
        }
    }
}

