/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.vast.cdm.common.DataSource;
import org.vast.ows.OWSException;
import org.vast.ows.sps.FeasibilityReport;
import org.vast.ows.sps.ReservationReport;
import org.vast.ows.sps.SPSException;
import org.vast.ows.sps.StatusReport;
import org.vast.ows.swe.SWESUtils;
import org.vast.swe.DataSourceDOM;
import org.vast.swe.SWEData;
import org.vast.swe.SWEUtils;
import org.vast.util.DateTime;
import org.vast.util.DateTimeFormat;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SPSCommonReaderV20 {
    protected SWEUtils sweUtils = new SWEUtils("2.0");
    protected DateTimeFormat timeFormat = new DateTimeFormat();

    public SWEData readSWEData(DOMHelper dom, Element paramsElt, DataComponent paramStructure) throws XMLReaderException {
        SWEData paramsData = new SWEData();
        try {
            Element encodingElt = dom.getElement(paramsElt, "encoding/*");
            DataEncoding dataEncoding = this.sweUtils.readEncoding(dom, encodingElt);
            paramsData.setElementType(paramStructure.copy());
            paramsData.setEncoding(dataEncoding);
            Element valuesElt = dom.getElement(paramsElt, "values");
            DataSourceDOM dataSource = new DataSourceDOM(dom, valuesElt);
            paramsData.parseData((DataSource)dataSource);
        }
        catch (IOException e) {
            throw new XMLReaderException("Error while parsing SWE Common data", (Node)paramsElt, (Exception)e);
        }
        return paramsData;
    }

    protected void readReportXML(DOMHelper dom, Element reportElt, StatusReport report) throws OWSException {
        try {
            String val = dom.getElementValue(reportElt, "description");
            report.setDescription(val);
            val = dom.getElementValue(reportElt, "identifier");
            report.setId(val);
            val = dom.getElementValue(reportElt, "name");
            report.setTitle(val);
            Map<QName, Object> extObjs = SWESUtils.readXMLExtensions(dom, reportElt);
            report.getExtensions().putAll(extObjs);
            val = dom.getElementValue(reportElt, "task");
            report.setTaskID(val);
            val = dom.getElementValue(reportElt, "estimatedToC");
            if (val != null) {
                DateTime estimatedToC = new DateTime(this.timeFormat.parseIso(val));
                report.setEstimatedToC(estimatedToC);
            }
            val = dom.getElementValue(reportElt, "event");
            report.setEventCode(val);
            val = dom.getElementValue(reportElt, "percentCompletion");
            if (val != null) {
                float pc = Float.parseFloat(val);
                report.setPercentCompletion(pc);
            }
            val = dom.getElementValue(reportElt, "procedure");
            report.setSensorID(val);
            val = dom.getElementValue(reportElt, "requestStatus");
            if (val != null) {
                report.setRequestStatus(StatusReport.RequestStatus.valueOf(val));
            }
            val = dom.getElementValue(reportElt, "statusMessage");
            report.setStatusMessage(val);
            val = dom.getElementValue(reportElt, "taskStatus");
            if (val != null) {
                report.setTaskStatus(StatusReport.TaskStatus.valueOf(val));
            }
            if ((val = dom.getElementValue(reportElt, "updateTime")) != null) {
                DateTime lastUpdate = new DateTime(this.timeFormat.parseIso(val));
                report.setLastUpdate(lastUpdate);
            }
        }
        catch (Exception e) {
            throw new SPSException(e);
        }
    }

    public StatusReport readReport(DOMHelper dom, Element reportElt) throws OWSException {
        StatusReport report = null;
        if (dom.hasQName((Node)reportElt, "sps:StatusNotification")) {
            report = this.readStatusReport(dom, reportElt);
        } else if (dom.hasQName((Node)reportElt, "sps:StatusReport")) {
            report = this.readStatusReport(dom, reportElt);
        } else if (dom.hasQName((Node)reportElt, "sps:ReservationReport")) {
            report = this.readReservationReport(dom, reportElt);
        } else if (dom.hasQName((Node)reportElt, "sps:FeasibilityReport")) {
            report = this.readFeasibilityReport(dom, reportElt);
        } else {
            throw new SPSException("InvalidRequest", null, null, "Invalid Report Type");
        }
        return report;
    }

    public StatusReport readStatusReport(DOMHelper dom, Element reportElt) throws OWSException {
        StatusReport report = new StatusReport();
        this.readReportXML(dom, reportElt, report);
        return report;
    }

    public ReservationReport readReservationReport(DOMHelper dom, Element reportElt) throws OWSException {
        try {
            ReservationReport report = new ReservationReport();
            this.readReportXML(dom, reportElt, report);
            String isoDate = dom.getElementValue(reportElt, "reservationExpiration");
            if (isoDate != null) {
                DateTime expiration = new DateTime(this.timeFormat.parseIso(isoDate));
                report.setReservationExpiration(expiration);
            }
            return report;
        }
        catch (Exception e) {
            throw new SPSException(e);
        }
    }

    public FeasibilityReport readFeasibilityReport(DOMHelper dom, Element reportElt) throws OWSException {
        try {
            FeasibilityReport report = new FeasibilityReport();
            this.readReportXML(dom, reportElt, report);
            return report;
        }
        catch (Exception e) {
            throw new SPSException(e);
        }
    }
}

