/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.io.IOException;
import org.vast.cdm.common.DataSink;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.sps.Alternative;
import org.vast.ows.sps.FeasibilityReport;
import org.vast.ows.sps.ReservationReport;
import org.vast.ows.sps.StatusReport;
import org.vast.ows.sps.Task;
import org.vast.ows.swe.SWESUtils;
import org.vast.swe.DataSinkDOM;
import org.vast.swe.SWEData;
import org.vast.swe.SWEUtils;
import org.vast.util.DateTime;
import org.vast.util.DateTimeFormat;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SPSCommonWriterV20 {
    protected SWEUtils sweUtils = new SWEUtils("2.0");
    protected DateTimeFormat timeFormat = new DateTimeFormat();

    public void writeSWEData(DOMHelper dom, Element parentElt, SWEData paramsData) throws XMLWriterException {
        Element paramDataElt = dom.addElement((Node)parentElt, "sps:ParameterData");
        try {
            Element encodingPropertyElt = dom.addElement((Node)paramDataElt, "sps:encoding");
            Element encodingElt = this.sweUtils.writeEncoding(dom, paramsData.getEncoding());
            encodingPropertyElt.appendChild(encodingElt);
            Element valuesElt = dom.addElement((Node)paramDataElt, "sps:values");
            DataSinkDOM dataSink = new DataSinkDOM(dom, valuesElt);
            paramsData.writeData((DataSink)dataSink);
        }
        catch (IOException e) {
            throw new XMLWriterException("Error while writing SWE Common data", (Node)paramDataElt, (Exception)e);
        }
    }

    protected void writeBaseReportAttributes(DOMHelper dom, Element reportElt, StatusReport report) throws XMLWriterException {
        StatusReport.TaskStatus taskStatus;
        float fval;
        DateTime date;
        dom.addUserPrefix("swes", OGCRegistry.getNamespaceURI((String)"SWES", (String)"2.0"));
        String val = report.getDescription();
        if (val != null) {
            dom.setElementValue(reportElt, "swes:description", val);
        }
        if ((val = report.getId()) != null) {
            dom.setElementValue(reportElt, "swes:identifier", val);
        }
        if ((val = report.getTitle()) != null) {
            dom.setElementValue(reportElt, "swes:name", val);
        }
        SWESUtils.writeXMLExtensions(dom, reportElt, "2.0", report.getExtensions());
        val = report.getTaskID();
        if (val != null) {
            dom.setElementValue(reportElt, "sps:task", val);
        }
        if ((date = report.getEstimatedToC()) != null) {
            dom.setElementValue(reportElt, "sps:estimatedToC", this.timeFormat.formatIso(date.getJulianTime(), 0));
        }
        if ((val = report.getEventCode()) != null) {
            dom.setElementValue(reportElt, "sps:event", val);
        }
        if (!Float.isNaN(fval = report.getPercentCompletion())) {
            dom.setElementValue(reportElt, "sps:percentCompletion", Float.toString(fval));
        }
        val = report.getSensorID();
        dom.setElementValue(reportElt, "sps:procedure", val);
        StatusReport.RequestStatus reqStatus = report.getRequestStatus();
        if (reqStatus != null) {
            dom.setElementValue(reportElt, "sps:requestStatus", reqStatus.name());
        }
        if ((val = report.getStatusMessage()) != null) {
            dom.setElementValue(reportElt, "sps:statusMessage", val);
        }
        if ((taskStatus = report.getTaskStatus()) != null) {
            dom.setElementValue(reportElt, "sps:taskStatus", taskStatus.name());
        }
        date = report.getLastUpdate();
        dom.setElementValue(reportElt, "sps:updateTime", this.timeFormat.formatIso(date.getJulianTime(), 0));
    }

    protected void writeStatusReportData(DOMHelper dom, Element reportElt, StatusReport report) throws XMLWriterException {
        this.writeBaseReportAttributes(dom, reportElt, report);
    }

    protected void writeAlternatives(DOMHelper dom, Element reportElt, FeasibilityReport report) throws XMLWriterException {
        dom.addUserPrefix("swes", OGCRegistry.getNamespaceURI((String)"SWES", (String)"2.0"));
        for (Alternative alt : report.getAlternatives()) {
            Element altElt = dom.addElement((Node)reportElt, "+sps:alternative/sps:Alternative");
            String val = alt.getDescription();
            if (val != null) {
                dom.setElementValue(altElt, "swes:description", val);
            }
            if ((val = alt.getId()) != null) {
                dom.setElementValue(altElt, "swes:identifier", val);
            }
            if ((val = alt.getTitle()) != null) {
                dom.setElementValue(altElt, "swes:name", val);
            }
            SWESUtils.writeXMLExtensions(dom, altElt, "2.0", alt.getExtensions());
            SWEData taskingParams = report.getTaskingParameters();
            Element property = dom.addElement((Node)reportElt, "sps:taskingParameters");
            this.writeSWEData(dom, property, taskingParams);
        }
    }

    protected void writeTaskParameters(DOMHelper dom, Element reportElt, StatusReport report) throws XMLWriterException {
        SWEData taskingParams = report.getTaskingParameters();
        if (taskingParams != null) {
            Element property = dom.addElement((Node)reportElt, "sps:taskingParameters");
            this.writeSWEData(dom, property, taskingParams);
        }
    }

    protected Element writeTask(DOMHelper dom, Task task) throws XMLWriterException {
        Element taskElt = dom.createElement("sps:Task");
        dom.addUserPrefix("swes", OGCRegistry.getNamespaceURI((String)"SWES", (String)"2.0"));
        String val = task.getDescription();
        if (val != null) {
            dom.setElementValue(taskElt, "swes:description", val);
        }
        if ((val = task.getId()) != null) {
            dom.setElementValue(taskElt, "swes:identifier", val);
        }
        if ((val = task.getTitle()) != null) {
            dom.setElementValue(taskElt, "swes:name", val);
        }
        SWESUtils.writeXMLExtensions(dom, taskElt, "2.0", task.getExtensions());
        for (StatusReport report : task.getStatusReports()) {
            Element reportElt = this.writeReport(dom, report);
            this.writeTaskParameters(dom, reportElt, report);
        }
        return taskElt;
    }

    public Element writeReport(DOMHelper dom, StatusReport report) throws XMLWriterException {
        if (report instanceof FeasibilityReport) {
            return this.writeFeasibilityReport(dom, (FeasibilityReport)report);
        }
        if (report instanceof ReservationReport) {
            return this.writeReservationReport(dom, (ReservationReport)report);
        }
        return this.writeStatusReport(dom, report);
    }

    public Element writeStatusReport(DOMHelper dom, StatusReport report) throws XMLWriterException {
        Element reportElt = dom.createElement("sps:StatusReport");
        this.writeStatusReportData(dom, reportElt, report);
        return reportElt;
    }

    public Element writeFeasibilityReport(DOMHelper dom, FeasibilityReport report) throws XMLWriterException {
        Element reportElt = dom.createElement("sps:StatusReport");
        this.writeStatusReportData(dom, reportElt, report);
        if (report.getAlternatives() != null) {
            this.writeAlternatives(dom, reportElt, report);
        }
        return reportElt;
    }

    public Element writeReservationReport(DOMHelper dom, ReservationReport report) throws XMLWriterException {
        Element reportElt = dom.createElement("sps:ReservationReport");
        this.writeStatusReportData(dom, reportElt, report);
        DateTime expDate = report.getReservationExpiration();
        if (expDate != null) {
            dom.setElementValue(reportElt, "sps:reservationExpiration", expDate.formatIso(0));
        }
        return reportElt;
    }
}

