/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.swe.v20.DataComponent;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSRequestReader;
import org.vast.ows.OWSUtils;
import org.vast.ows.SweEncodedMessageProcessor;
import org.vast.ows.sps.DescribeTaskingResponse;
import org.vast.ows.sps.GetStatusResponse;
import org.vast.ows.sps.TaskingResponse;
import org.vast.ows.swe.SWESUtils;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class SPSUtils
extends OWSUtils {
    public static String EVENT_TASK_EXPIRED = "TaskingRequestExpired";
    public static String EVENT_TASK_SUBMITTED = "TaskSubmitted";
    public static String EVENT_TASK_COMPLETED = "TaskCompleted";
    public static String EVENT_DATA_PUBLISHED = "DataPublished";
    public static String EVENT_TASK_FAILED = "TaskFailed";
    public static String EVENT_TASK_CANCELLED = "TaskCancelled";
    public static String EVENT_TASK_UPDATED = "TaskUpdated";
    public static String EVENT_TASK_RESERVED = "TaskReserved";
    public static String EVENT_TASK_CONFIRMED = "TaskConfirmed";
    public static String EVENT_RESERVATION_EXPIRED = "ReservationExpired";

    public OWSRequest readSpsRequest(DOMHelper dom, Element requestElt, DataComponent sweParams) throws OWSException {
        OWSRequest request = new OWSRequest();
        AbstractRequestReader.readCommonXML(dom, requestElt, request);
        OWSExceptionReport report = new OWSExceptionReport();
        AbstractRequestReader.checkParameters(request, report, "SPS");
        report.process();
        try {
            OWSRequestReader reader = (OWSRequestReader)OGCRegistry.createReader((String)"SPS", (String)request.getOperation(), (String)request.getVersion());
            if (reader instanceof SweEncodedMessageProcessor) {
                ((SweEncodedMessageProcessor)((Object)reader)).setSweCommonStructure(sweParams, null);
            }
            return reader.readXMLQuery(dom, requestElt);
        }
        catch (IllegalStateException e) {
            String spec = "SPS " + request.getOperation() + " v" + request.getVersion();
            throw new OWSException("No support for " + spec, e);
        }
    }

    public DescribeTaskingResponse readDescribeTaskingResponse(DOMHelper dom, Element respElt) throws OWSException {
        DescribeTaskingResponse resp = (DescribeTaskingResponse)this.readXMLResponse(dom, respElt, "SPS", "DescribeTaskingResponse");
        return resp;
    }

    public DescribeTaskingResponse readDescribeTaskingResponse(Element respElt) throws OWSException {
        DOMHelper dom = new DOMHelper(respElt.getOwnerDocument());
        return this.readDescribeTaskingResponse(dom, respElt);
    }

    public TaskingResponse<?> readTaskingResponse(DOMHelper dom, Element respElt, String version) throws OWSException {
        return (TaskingResponse)super.readXMLResponse(dom, respElt, "SPS", respElt.getLocalName(), version);
    }

    public GetStatusResponse readStatusResponse(DOMHelper dom, Element respElt, String version) throws OWSException {
        return (GetStatusResponse)super.readXMLResponse(dom, respElt, "SPS", respElt.getLocalName(), version);
    }

    public static void writeXMLExtensions(DOMHelper dom, Element parentElt, String version, Map<QName, Object> extObjs) {
        String spsUri = OGCRegistry.getNamespaceURI((String)"SPS", (String)version);
        SWESUtils.writeXMLExtensions(dom, parentElt, "sps", spsUri, extObjs);
    }
}

