/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.vast.swe.SWEData;
import org.vast.util.DateTime;
import org.w3c.dom.Element;

public class StatusReport
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -2881367421680156901L;
    protected String description;
    protected String title;
    protected String id;
    protected Map<QName, Object> extensions;
    protected String taskID;
    protected DateTime estimatedToC;
    protected String eventCode;
    protected float percentCompletion = Float.NaN;
    protected String sensorID;
    protected RequestStatus requestStatus;
    protected String statusMessage;
    protected TaskStatus taskStatus;
    protected DateTime lastUpdate;
    protected SWEData taskingParameters;

    public StatusReport() {
        this.extensions = new HashMap<QName, Object>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public void setTaskID(String id) {
        this.taskID = id;
    }

    public String getSensorID() {
        return this.sensorID;
    }

    public void setSensorID(String sensorId) {
        this.sensorID = sensorId;
    }

    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(DateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public RequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public void setRequestStatus(RequestStatus statusCode) {
        this.requestStatus = statusCode;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(TaskStatus statusCode) {
        this.taskStatus = statusCode;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }

    public float getPercentCompletion() {
        return this.percentCompletion;
    }

    public void setPercentCompletion(float percentCompletion) {
        this.percentCompletion = percentCompletion;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SWEData getTaskingParameters() {
        return this.taskingParameters;
    }

    public void setTaskingParameters(SWEData taskingParameters) {
        this.taskingParameters = taskingParameters;
    }

    public DateTime getEstimatedToC() {
        return this.estimatedToC;
    }

    public double getEstimatedDelay() {
        double toc = this.estimatedToC.getJulianTime();
        double now = new DateTime().getJulianTime();
        return toc - now;
    }

    public void setEstimatedToC(DateTime estimatedToC) {
        this.estimatedToC = estimatedToC;
    }

    public void setEstimatedDelay(int seconds) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.add(13, seconds);
        cal.set(14, 0);
        this.estimatedToC = new DateTime(cal.getTimeInMillis());
    }

    public void touch() {
        this.lastUpdate = new DateTime();
    }

    public Map<QName, Object> getExtensions() {
        return this.extensions;
    }

    public void addExtension(Element extElt) {
        QName qname = new QName(extElt.getNamespaceURI(), extElt.getLocalName());
        this.extensions.put(qname, extElt);
    }

    public StatusReport clone() {
        try {
            return (StatusReport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static enum TaskStatus {
        Reserved,
        InExecution,
        Completed,
        Cancelled,
        Expired,
        Failed;

    }

    public static enum RequestStatus {
        Pending,
        Accepted,
        Rejected;

    }
}

