/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.opengis.swe.v20.ValidationException;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.OWSRequest;
import org.vast.ows.ParameterizedRequest;
import org.vast.ows.sps.SPSException;
import org.vast.swe.SWEData;
import org.vast.util.DateTime;

public abstract class TaskingRequest
extends OWSRequest
implements ParameterizedRequest {
    protected String procedureID;
    protected SWEData taskingParameters;
    protected DateTime latestResponseTime;

    public String getProcedureID() {
        return this.procedureID;
    }

    public void setProcedureID(String sensorID) {
        this.procedureID = sensorID;
    }

    @Override
    public SWEData getParameters() {
        return this.taskingParameters;
    }

    @Override
    public void setParameters(SWEData taskingParameters) {
        this.taskingParameters = taskingParameters;
    }

    public DateTime getLatestResponseTime() {
        return this.latestResponseTime;
    }

    public void setLatestResponseTime(DateTime latestResponseTime) {
        this.latestResponseTime = latestResponseTime;
    }

    public void setMaxResponseDelay(int seconds) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.add(13, seconds);
        cal.set(14, 0);
        this.latestResponseTime = new DateTime(cal.getTimeInMillis());
    }

    public void validate() throws OWSException {
        ArrayList errorList = new ArrayList();
        this.taskingParameters.validateData(errorList);
        if (errorList.size() == 0) {
            return;
        }
        OWSExceptionReport report = new OWSExceptionReport();
        for (int i = 0; i < errorList.size(); ++i) {
            String loc = ((ValidationException)errorList.get(i)).getLocator();
            String msg = ((ValidationException)errorList.get(i)).getMessage();
            report.add(new SPSException("InvalidParameterValue", "taskingParameters/" + loc, null, msg));
        }
        throw report;
    }
}

