/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.SweEncodedMessageProcessor;
import org.vast.ows.sps.SPSCommonReaderV20;
import org.vast.ows.sps.SPSException;
import org.vast.ows.sps.TaskingRequest;
import org.vast.ows.swe.SWERequestReader;
import org.vast.swe.SWEData;
import org.vast.util.DateTime;
import org.vast.util.DateTimeFormat;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public abstract class TaskingRequestReaderV20<RequestType extends TaskingRequest>
extends SWERequestReader<RequestType>
implements SweEncodedMessageProcessor {
    protected SPSCommonReaderV20 commonReader = new SPSCommonReaderV20();
    protected DateTimeFormat timeFormat = new DateTimeFormat();
    protected DataComponent taskingParamStructure;

    @Override
    public void setSweCommonStructure(DataComponent taskingParamStructure, DataEncoding resultEncoding) {
        this.taskingParamStructure = taskingParamStructure;
    }

    public void readTaskingRequestXML(DOMHelper dom, Element requestElt, RequestType request) throws OWSException {
        try {
            TaskingRequestReaderV20.readCommonXML(dom, requestElt, request);
            String sensorID = dom.getElementValue(requestElt, "procedure");
            ((TaskingRequest)request).setProcedureID(sensorID);
            try {
                Element taskingParamsElt = dom.getElement(requestElt, "taskingParameters/*");
                if (taskingParamsElt != null && this.taskingParamStructure != null) {
                    SWEData taskingParams = this.commonReader.readSWEData(dom, taskingParamsElt, this.taskingParamStructure);
                    ((TaskingRequest)request).setParameters(taskingParams);
                }
            }
            catch (Exception e) {
                String code = "InvalidParameterValue";
                String locator = "taskingParameters";
                throw new SPSException(code, locator, "Invalid XML Request: " + e.getMessage(), e);
            }
            String isoDate = dom.getElementValue(requestElt, "latestResponseTime");
            try {
                if (isoDate != null) {
                    DateTime latestResponseTime = new DateTime(this.timeFormat.parseIso(isoDate));
                    ((TaskingRequest)request).setLatestResponseTime(latestResponseTime);
                }
            }
            catch (Exception e) {
                String code = "InvalidParameterValue";
                String locator = "latestResponseTime";
                throw new SPSException(code, locator, "Invalid Value for " + locator + ": " + isoDate, e);
            }
        }
        catch (SPSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SPSException("Invalid XML Request: " + e.getMessage(), e);
        }
    }

    protected void checkParameters(RequestType request, OWSExceptionReport report) throws OWSException {
        TaskingRequestReaderV20.checkParameters(request, report, "SPS");
        if (((TaskingRequest)request).getProcedureID() == null) {
            report.add(new SPSException("MissingParameterValue", "procedure"));
        }
        if (((TaskingRequest)request).getParameters() == null) {
            report.add(new SPSException("MissingParameterValue", "taskingParameters"));
        }
        report.process();
    }
}

