/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.sps.SPSCommonWriterV20;
import org.vast.ows.sps.SPSException;
import org.vast.ows.sps.TaskingRequest;
import org.vast.ows.swe.SWERequestWriter;
import org.vast.swe.SWEData;
import org.vast.util.DateTime;
import org.vast.util.DateTimeFormat;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TaskingRequestWriterV20<RequestType extends TaskingRequest>
extends SWERequestWriter<RequestType> {
    protected SPSCommonWriterV20 commonWriter = new SPSCommonWriterV20();
    protected DateTimeFormat timeFormat = new DateTimeFormat();

    @Override
    public Element buildXMLQuery(DOMHelper dom, RequestType request) throws OWSException {
        try {
            DateTime latestResponseTime;
            SWEData taskingParams;
            dom.addUserPrefix("sps", OGCRegistry.getNamespaceURI((String)"SPS", (String)((OWSRequest)request).getVersion()));
            Element rootElt = dom.createElement("sps:" + ((OWSRequest)request).getOperation());
            this.addCommonXML(dom, rootElt, (OWSRequest)request);
            if (((TaskingRequest)request).getProcedureID() != null) {
                dom.setElementValue(rootElt, "sps:procedure", ((TaskingRequest)request).getProcedureID());
            }
            if ((taskingParams = ((TaskingRequest)request).getParameters()) != null) {
                Element taskingParamsElt = dom.addElement((Node)rootElt, "sps:taskingParameters");
                this.commonWriter.writeSWEData(dom, taskingParamsElt, taskingParams);
            }
            if ((latestResponseTime = ((TaskingRequest)request).getLatestResponseTime()) != null) {
                String isoTime = this.timeFormat.formatIso(latestResponseTime.getJulianTime(), 0);
                dom.setElementValue(rootElt, "sps:latestResponseTime", isoTime);
            }
            return rootElt;
        }
        catch (XMLWriterException e) {
            throw new SPSException("Error while building tasking request", (Exception)((Object)e));
        }
    }
}

