/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import org.vast.ows.OWSException;
import org.vast.ows.sps.SPSCommonReaderV20;
import org.vast.ows.sps.SPSException;
import org.vast.ows.sps.StatusReport;
import org.vast.ows.sps.TaskingResponse;
import org.vast.ows.swe.SWEResponseReader;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class TaskingResponseReaderV20
extends SWEResponseReader<TaskingResponse<?>> {
    protected SPSCommonReaderV20 commonReader = new SPSCommonReaderV20();

    @Override
    public TaskingResponse<StatusReport> readXMLResponse(DOMHelper dom, Element responseElt) throws OWSException {
        try {
            String respName = responseElt.getLocalName();
            String className = this.getClass().getPackage().getName() + "." + respName;
            try {
                Class<?> respClass = Class.forName(className);
                TaskingResponse response = (TaskingResponse)respClass.newInstance();
                response.setVersion("2.0");
                Element reportElt = dom.getElement(responseElt, "result/*");
                if (reportElt != null) {
                    StatusReport report = this.commonReader.readReport(dom, reportElt);
                    response.setReport(report);
                }
                this.readXMLExtensions(dom, responseElt, response);
                return response;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Error while instantiating SPS response Class " + className, e);
            }
        }
        catch (Exception e) {
            throw new SPSException(e);
        }
    }
}

