/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.sps;

import java.util.Map;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sps.SPSException;
import org.vast.ows.sps.TaskingRequestReaderV20;
import org.vast.ows.sps.UpdateRequest;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class UpdateRequestReaderV20
extends TaskingRequestReaderV20<UpdateRequest> {
    @Override
    public UpdateRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        throw new SPSException("KVP request not supported in SPS 2.0 Update");
    }

    @Override
    public UpdateRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        UpdateRequest request = new UpdateRequest();
        this.readTaskingRequestXML(dom, requestElt, request);
        String taskID = dom.getElementValue(requestElt, "targetTask");
        request.setTaskID(taskID);
        this.checkParameters(request, new OWSExceptionReport());
        return request;
    }

    @Override
    protected void checkParameters(UpdateRequest request, OWSExceptionReport report) throws OWSException {
        super.checkParameters(request, report);
        if (request.getTaskID() == null) {
            report.add(new SPSException("MissingParameterValue", "targetTask"));
        }
        report.process();
    }
}

