/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.swe;

import java.util.Map;
import org.vast.ogc.gml.GMLUtils;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.sos.SOSException;
import org.vast.ows.swe.DescribeSensorRequest;
import org.vast.ows.swe.SWERequestReader;
import org.vast.util.TimeExtent;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;

public class DescribeSensorReaderV20
extends SWERequestReader<DescribeSensorRequest> {
    protected GMLUtils gmlUtils = new GMLUtils("3.2");

    @Override
    public DescribeSensorRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        DescribeSensorRequest request = new DescribeSensorRequest();
        this.readCommonQueryArguments(queryParameters, request);
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("validTime")) {
                TimeExtent time = this.parseTimeArg(argValue);
                request.setTime(time);
                continue;
            }
            if (argName.equalsIgnoreCase("procedure")) {
                request.setProcedureID(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("procedureDescriptionFormat")) {
                request.setFormat(argValue);
                continue;
            }
            throw new SOSException("Invalid KVP Request: Unknown Argument " + argName);
        }
        this.checkParameters(request, report);
        return request;
    }

    @Override
    public DescribeSensorRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        DescribeSensorRequest request = new DescribeSensorRequest();
        DescribeSensorReaderV20.readCommonXML(dom, requestElt, request);
        String procedure = dom.getElementValue(requestElt, "procedure");
        request.setProcedureID(procedure);
        String format = dom.getElementValue(requestElt, "procedureDescriptionFormat");
        request.setFormat(format);
        try {
            Element timeElt = dom.getElement(requestElt, "validTime/*");
            if (timeElt != null) {
                TimeExtent time = this.gmlUtils.readTimePrimitiveAsTimeExtent(dom, timeElt);
                request.setTime(time);
            }
        }
        catch (XMLReaderException e) {
            report.add(new OWSException("InvalidParameterValue", "validTime"));
        }
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(DescribeSensorRequest request, OWSExceptionReport report) throws OWSException {
        super.checkParameters(request, report);
        if (request.getProcedureID() == null) {
            report.add(new OWSException("MissingParameterValue", "procedure"));
        }
        if (request.getFormat() == null) {
            report.add(new OWSException("MissingParameterValue", "procedureDescriptionFormat"));
        }
        report.process();
    }
}

