/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.swe;

import java.util.LinkedHashMap;
import java.util.Map;
import org.vast.ogc.OGCRegistry;
import org.vast.ogc.gml.GMLUtils;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.swe.DescribeSensorRequest;
import org.vast.util.TimeExtent;
import org.vast.xml.DOMHelper;
import org.vast.xml.XMLWriterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DescribeSensorWriterV20
extends AbstractRequestWriter<DescribeSensorRequest> {
    protected GMLUtils gmlUtils = new GMLUtils("3.2");

    @Override
    public Map<String, String> buildURLParameters(DescribeSensorRequest request) throws OWSException {
        LinkedHashMap<String, String> urlParams = new LinkedHashMap<String, String>();
        this.addCommonArgs(urlParams, (OWSRequest)request);
        urlParams.put("procedure", request.getProcedureID());
        urlParams.put("procedureDescriptionFormat", request.getFormat());
        if (request.getTime() != null) {
            StringBuilder buf = new StringBuilder();
            this.writeTimeArgument(buf, request.getTime());
            urlParams.put("validTime", buf.toString());
        }
        return urlParams;
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, DescribeSensorRequest request) throws OWSException {
        dom.addUserPrefix("swes", OGCRegistry.getNamespaceURI((String)"SWES", (String)"2.0"));
        Element rootElt = dom.createElement("swes:DescribeSensor");
        this.addCommonXML(dom, rootElt, request);
        dom.setElementValue(rootElt, "swes:procedure", request.getProcedureID());
        dom.setElementValue(rootElt, "swes:procedureDescriptionFormat", request.getFormat());
        TimeExtent timeExtent = request.getTime();
        if (timeExtent != null) {
            try {
                Element timeElt = this.gmlUtils.writeTimeExtentAsTimePrimitive(dom, timeExtent);
                Element elt = dom.addElement((Node)rootElt, "swes:validTime");
                elt.appendChild(timeElt);
            }
            catch (XMLWriterException e) {
                throw new OWSException(e.getMessage());
            }
        }
        return rootElt;
    }
}

