/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.swe;

import java.util.ArrayList;
import java.util.Collection;
import org.vast.ows.OWSCapabilitiesReaderV11;
import org.vast.ows.OWSException;
import org.vast.ows.swe.SWESOfferingCapabilities;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class SWESCapabilitiesReaderV20
extends OWSCapabilitiesReaderV11 {
    protected void readCommonOfferingProperties(DOMHelper dom, Element offeringElt, SWESOfferingCapabilities offering, Collection<String> serviceProcFormats, Collection<String> serviceObsProperties, Collection<String> serviceRelFeatures) throws OWSException {
        String id = dom.getElementValue(offeringElt, "identifier");
        offering.setIdentifier(id);
        String name = dom.getElementValue(offeringElt, "name");
        offering.setTitle(name);
        String description = dom.getElementValue(offeringElt, "description");
        offering.setDescription(description);
        String procedureID = dom.getElementValue(offeringElt, "procedure");
        offering.getProcedures().add(procedureID);
        this.readProcedureFormats(dom, offeringElt, offering.getProcedureFormats());
        if (offering.getProcedureFormats().isEmpty()) {
            offering.getProcedureFormats().addAll(serviceProcFormats);
        }
        this.readObservableProperties(dom, offeringElt, offering.getObservableProperties());
        if (offering.getObservableProperties().isEmpty()) {
            offering.getObservableProperties().addAll(serviceObsProperties);
        }
        this.readRelatedFeatures(dom, offeringElt, offering.getRelatedFeatures());
        if (offering.getRelatedFeatures().isEmpty()) {
            offering.getRelatedFeatures().addAll(serviceRelFeatures);
        }
    }

    protected Collection<String> readProcedureFormats(DOMHelper dom, Element parentElt, Collection<String> procFormats) {
        return this.readStringList(dom, parentElt, "procedureDescriptionFormat", procFormats);
    }

    protected Collection<String> readObservableProperties(DOMHelper dom, Element parentElt, Collection<String> observables) {
        return this.readStringList(dom, parentElt, "observableProperty", observables);
    }

    protected Collection<String> readRelatedFeatures(DOMHelper dom, Element parentElt, Collection<String> relatedFeatures) {
        if (relatedFeatures == null) {
            relatedFeatures = new ArrayList<String>();
        }
        NodeList featRelationshipElts = dom.getElements(parentElt, "relatedFeature/FeatureRelationship/target");
        for (int i = 0; i < featRelationshipElts.getLength(); ++i) {
            String href = dom.getAttributeValue((Element)featRelationshipElts.item(i), "@href");
            relatedFeatures.add(href);
        }
        return relatedFeatures;
    }

    protected Collection<String> readStringList(DOMHelper dom, Element parentElt, String eltPath, Collection<String> tokenList) {
        if (tokenList == null) {
            tokenList = new ArrayList<String>();
        }
        NodeList elts = dom.getElements(parentElt, eltPath);
        for (int i = 0; i < elts.getLength(); ++i) {
            String token = dom.getElementValue((Element)elts.item(i));
            tokenList.add(token);
        }
        return tokenList;
    }
}

