/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.swe;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.vast.ows.OWSCapabilitiesWriterV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSLayerCapabilities;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.swe.SWESOfferingCapabilities;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public abstract class SWESCapabilitiesWriterV20
extends OWSCapabilitiesWriterV11 {
    protected void writeCommonContentsProperties(DOMHelper dom, Element contentsElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        for (String token : this.getCommonListEntries(serviceCaps, "getProcedureFormats")) {
            dom.setElementValue(contentsElt, "+swes:procedureDescriptionFormat", token);
        }
        for (String token : this.getCommonListEntries(serviceCaps, "getObservableProperties")) {
            dom.setElementValue(contentsElt, "+swes:observableProperty", token);
        }
        for (String token : this.getCommonListEntries(serviceCaps, "getRelatedFeatures")) {
            this.addRelatedFeature(dom, contentsElt, token);
        }
    }

    protected void writeCommonOfferingProperties(DOMHelper dom, Element offeringElt, OWSServiceCapabilities serviceCaps, SWESOfferingCapabilities offeringCaps) {
        String desc = offeringCaps.getDescription();
        if (desc != null) {
            dom.setElementValue(offeringElt, "swes:description", desc);
        }
        dom.setElementValue(offeringElt, "swes:identifier", offeringCaps.getIdentifier());
        String title = offeringCaps.getTitle();
        if (title != null) {
            dom.setElementValue(offeringElt, "+swes:name", title);
        }
        if (!offeringCaps.getProcedures().isEmpty()) {
            dom.setElementValue(offeringElt, "swes:procedure", offeringCaps.getProcedures().iterator().next());
        }
        if (!offeringCaps.getProcedureFormats().equals(this.getCommonListEntries(serviceCaps, "getProcedureFormats"))) {
            for (String token : offeringCaps.getProcedureFormats()) {
                dom.setElementValue(offeringElt, "+swes:procedureDescriptionFormat", token);
            }
        }
        if (!offeringCaps.getObservableProperties().equals(this.getCommonListEntries(serviceCaps, "getObservableProperties"))) {
            for (String token : offeringCaps.getObservableProperties()) {
                dom.setElementValue(offeringElt, "+swes:observableProperty", token);
            }
        }
        if (!offeringCaps.getRelatedFeatures().equals(this.getCommonListEntries(serviceCaps, "getRelatedFeatures"))) {
            for (String token : offeringCaps.getRelatedFeatures()) {
                this.addRelatedFeature(dom, offeringElt, token);
            }
        }
    }

    protected void addRelatedFeature(DOMHelper dom, Element parentElt, String featureURI) {
        dom.setAttributeValue(parentElt, "+swes:relatedFeature/swes:FeatureRelationship/swes:target/@xlink:href", featureURI);
    }

    protected Collection<String> getCommonListEntries(OWSServiceCapabilities caps, String getListMethodName) {
        if (caps.getLayers().size() <= 1) {
            return Collections.EMPTY_SET;
        }
        Set firstSet = null;
        for (OWSLayerCapabilities oWSLayerCapabilities : caps.getLayers()) {
            try {
                Set tokenSet = (Set)oWSLayerCapabilities.getClass().getMethod(getListMethodName, new Class[0]).invoke((Object)oWSLayerCapabilities, new Object[0]);
                if (firstSet != null && !tokenSet.equals(firstSet)) {
                    return Collections.EMPTY_SET;
                }
                firstSet = tokenSet;
            }
            catch (Exception exception) {}
        }
        return firstSet;
    }
}

