/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.swe;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.vast.ogc.OGCRegistry;
import org.vast.util.DateTimeFormat;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SWESUtils {
    public static Map<QName, Object> readXMLExtensions(DOMHelper dom, Element parentElt) {
        NodeList extensions = dom.getElements(parentElt, "extension");
        HashMap<QName, Object> extList = new HashMap<QName, Object>();
        for (int i = 0; i < extensions.getLength(); ++i) {
            Element extElt = (Element)extensions.item(i);
            Element contentElt = dom.getFirstChildElement(extElt);
            contentElt = (Element)extElt.removeChild(contentElt);
            QName extName = new QName(contentElt.getNamespaceURI(), contentElt.getLocalName());
            extList.put(extName, contentElt);
        }
        return extList;
    }

    public static void writeXMLExtensions(DOMHelper dom, Element parentElt, String prefix, String nsUri, Map<QName, Object> extObjs) {
        if (extObjs == null) {
            return;
        }
        dom.addUserPrefix(prefix, nsUri);
        for (Map.Entry<QName, Object> extObj : extObjs.entrySet()) {
            Element extContent = null;
            QName extName = extObj.getKey();
            Object extValue = extObj.getValue();
            if (extValue instanceof Element) {
                extContent = (Element)((Object)extObj);
                dom.getDocument().adoptNode(extContent);
            } else if (extValue instanceof String || extValue instanceof Number || extValue instanceof Boolean) {
                extContent = dom.getDocument().createElementNS(extName.getNamespaceURI(), extName.getLocalPart());
                dom.setElementValue(extContent, extValue.toString());
            } else if (extValue instanceof Date) {
                extContent = dom.getDocument().createElementNS(extName.getNamespaceURI(), extName.getLocalPart());
                dom.setElementValue(extContent, new DateTimeFormat().formatIso((double)((Date)extValue).getTime() / 1000.0, 0));
            }
            if (extContent == null) continue;
            Element extElt = dom.createElement(prefix + ":extension");
            extElt.appendChild(extContent);
            parentElt.appendChild(extElt);
        }
    }

    public static void writeXMLExtensions(DOMHelper dom, Element parentElt, String version, Map<QName, Object> extObjs) {
        String swesUri = OGCRegistry.getNamespaceURI((String)"SWES", (String)version);
        SWESUtils.writeXMLExtensions(dom, parentElt, "swes", swesUri, extObjs);
    }

    public static Object findExtension(String nsUri, String localName, Map<QName, Object> extObjs) {
        QName qname = new QName(nsUri, localName);
        Object obj = extObjs.get(qname);
        return obj;
    }

    public static void addExtension(String nsUri, String localName, Object ext, Map<QName, Object> extObjs) {
        QName qname = new QName(nsUri, localName);
        extObjs.put(qname, ext);
    }
}

