/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import org.vast.ows.AbstractResponseReader;
import org.vast.ows.OWSCommonReaderV11;
import org.vast.ows.OWSException;
import org.vast.ows.wcs.CoverageDescription;
import org.vast.ows.wcs.CoverageDescriptions;
import org.vast.ows.wcs.RangeAxis;
import org.vast.ows.wcs.RangeField;
import org.vast.ows.wcs.WCSCommonReaderV11;
import org.vast.ows.wcs.WCSRectifiedGridCrs;
import org.vast.util.Bbox;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoverageDescriptionsReaderV11
extends AbstractResponseReader<CoverageDescriptions> {
    protected WCSCommonReaderV11 wcsReader = new WCSCommonReaderV11();
    protected OWSCommonReaderV11 owsReader = new OWSCommonReaderV11();

    @Override
    public CoverageDescriptions readXMLResponse(DOMHelper dom, Element responseElt) throws OWSException {
        CoverageDescriptions response = new CoverageDescriptions();
        response.setVersion("1.1.1");
        if (responseElt.getLocalName().equals("CoverageDescription")) {
            CoverageDescription desc = this.readDescription(dom, responseElt);
            response.getDescriptions().add(desc);
        } else {
            NodeList descElts = dom.getElements(responseElt, "CoverageDescription");
            for (int i = 0; i < descElts.getLength(); ++i) {
                Element descElt = (Element)descElts.item(i);
                CoverageDescription desc = this.readDescription(dom, descElt);
                response.getDescriptions().add(desc);
            }
        }
        return response;
    }

    protected CoverageDescription readDescription(DOMHelper dom, Element descElt) throws OWSException {
        CoverageDescription desc = new CoverageDescription();
        this.owsReader.readIdentification(dom, descElt, desc);
        Element spDomainElt = dom.getElement(descElt, "Domain/SpatialDomain");
        NodeList bboxElts = dom.getElements(spDomainElt, "BoundingBox");
        for (int j = 0; j < bboxElts.getLength(); ++j) {
            Element bboxElt = (Element)bboxElts.item(j);
            Bbox bbox = this.owsReader.readBbox(dom, bboxElt);
            desc.getBboxList().add(bbox);
        }
        Element gridElt = dom.getElement(spDomainElt, "GridCRS");
        if (gridElt != null) {
            WCSRectifiedGridCrs gridCrs = new WCSRectifiedGridCrs();
            this.wcsReader.readGridCRS(dom, gridElt, gridCrs);
        }
        NodeList fieldElts = dom.getElements(descElt, "Range/Field");
        for (int j = 0; j < fieldElts.getLength(); ++j) {
            Element fieldElt = (Element)fieldElts.item(j);
            RangeField field = new RangeField();
            this.owsReader.readIdentification(dom, fieldElt, field);
            try {
                String nullValue = dom.getElementValue(fieldElt, "NullValue");
                if (nullValue != null) {
                    field.setNullValue(Double.parseDouble(nullValue));
                }
            }
            catch (NumberFormatException nullValue) {
                // empty catch block
            }
            NodeList interpElts = dom.getElements(fieldElt, "InterpolationMethods/InterpolationMethod");
            for (int k = 0; k < interpElts.getLength(); ++k) {
                Element interpElt = (Element)interpElts.item(k);
                String methodName = dom.getElementValue(interpElt);
                field.getInterpolationMethods().add(methodName);
            }
            String defaultMethod = dom.getElementValue(fieldElt, "InterpolationMethods/Default");
            field.setDefaultInterpolationMethod(defaultMethod);
            NodeList axisElts = dom.getElements(fieldElt, "Axis");
            for (int k = 0; k < axisElts.getLength(); ++k) {
                Element axisElt = (Element)axisElts.item(k);
                RangeAxis axis = new RangeAxis();
                this.owsReader.readDescription(dom, axisElt, axis);
                String id = dom.getAttributeValue(axisElt, "@identifier");
                axis.setIdentifier(id);
                NodeList keyElts = dom.getElements(axisElt, "AvailableKeys/Key");
                for (int h = 0; h < keyElts.getLength(); ++h) {
                    Element keyElt = (Element)keyElts.item(h);
                    String key = dom.getElementValue(keyElt);
                    axis.getKeys().add(key);
                }
                field.getAxisList().add(axis);
            }
            desc.getRangeFields().add(field);
        }
        this.readCRSList(desc, dom, descElt);
        this.readFormatList(desc, dom, descElt);
        return desc;
    }

    protected void readFormatList(CoverageDescription desc, DOMHelper dom, Element descElt) {
        NodeList formatElts = dom.getElements(descElt, "SupportedFormat");
        int numElts = formatElts.getLength();
        for (int i = 0; i < numElts; ++i) {
            Element formatElt = (Element)formatElts.item(i);
            String formatName = dom.getElementValue(formatElt);
            desc.getFormatList().add(formatName);
        }
    }

    protected void readCRSList(CoverageDescription desc, DOMHelper dom, Element descElt) {
        NodeList crsElts = dom.getElements(descElt, "SupportedCRS");
        int numElts = crsElts.getLength();
        for (int i = 0; i < numElts; ++i) {
            Element crsElt = (Element)crsElts.item(i);
            String crsName = dom.getElementValue(crsElt);
            desc.getCrsList().add(crsName);
        }
    }
}

