/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import java.util.List;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractResponseWriter;
import org.vast.ows.OWSCommonWriterV11;
import org.vast.ows.OWSException;
import org.vast.ows.wcs.CoverageDescription;
import org.vast.ows.wcs.CoverageDescriptions;
import org.vast.ows.wcs.RangeAxis;
import org.vast.ows.wcs.RangeField;
import org.vast.ows.wcs.WCSCommonWriterV11;
import org.vast.ows.wcs.WCSRectifiedGridCrs;
import org.vast.util.Bbox;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CoverageDescriptionsWriterV11
extends AbstractResponseWriter<CoverageDescriptions> {
    protected WCSCommonWriterV11 wcsWriter = new WCSCommonWriterV11();
    protected OWSCommonWriterV11 owsWriter = new OWSCommonWriterV11();

    @Override
    public Element buildXMLResponse(DOMHelper dom, CoverageDescriptions response, String version) throws OWSException {
        dom.addUserPrefix("_NIL_", OGCRegistry.getNamespaceURI((String)"WCS", (String)version));
        Element rootElt = dom.createElement("CoverageDescriptions");
        List<CoverageDescription> descriptions = response.getDescriptions();
        for (int i = 0; i < descriptions.size(); ++i) {
            CoverageDescription desc = descriptions.get(i);
            Element descElt = dom.addElement((Node)rootElt, "+CoverageDescription");
            this.owsWriter.buildDescription(dom, descElt, desc);
            dom.setElementValue(descElt, "Identifier", desc.getIdentifier());
            Element spDomainElt = dom.addElement((Node)descElt, "Domain/SpatialDomain");
            List<Bbox> bboxList = desc.getBboxList();
            for (int j = 0; j < bboxList.size(); ++j) {
                Element bboxElt = this.owsWriter.buildBbox(dom, bboxList.get(j));
                spDomainElt.appendChild(bboxElt);
            }
            WCSRectifiedGridCrs gridCrs = desc.getGridCrs();
            if (gridCrs != null) {
                String id = desc.getIdentifier() + "_GRID_CRS";
                Element gridCrsElt = this.wcsWriter.buildGridCRS(dom, gridCrs, id);
                spDomainElt.appendChild(gridCrsElt);
            }
            for (int j = 0; j < desc.getRangeFields().size(); ++j) {
                RangeField field = desc.getRangeFields().get(j);
                Element fieldElt = dom.addElement((Node)descElt, "Range/Field");
                this.owsWriter.buildDescription(dom, fieldElt, field);
                dom.setElementValue(fieldElt, "Identifier", field.getIdentifier());
                dom.addElement((Node)fieldElt, "Definition/ows:AnyValue");
                String nullValue = field.getNullValue().toString();
                dom.setElementValue(fieldElt, "NullValue", nullValue);
                for (int k = 0; k < field.getInterpolationMethods().size(); ++k) {
                    Element interpMethodElt = dom.addElement((Node)fieldElt, "InterpolationMethods/+InterpolationMethod");
                    String interpMethod = field.getInterpolationMethods().get(k);
                    if (interpMethod.startsWith("nearest")) {
                        interpMethod = "nearest";
                    }
                    dom.setElementValue(interpMethodElt, interpMethod);
                }
                String defaultMethod = field.getDefaultInterpolationMethod();
                if (defaultMethod != null) {
                    dom.setElementValue(fieldElt, "InterpolationMethods/Default", defaultMethod);
                }
                for (int k = 0; k < field.getAxisList().size(); ++k) {
                    RangeAxis axis = field.getAxisList().get(k);
                    Element axisElt = dom.addElement((Node)fieldElt, "Axis");
                    this.owsWriter.buildDescription(dom, axisElt, axis);
                    dom.setAttributeValue(axisElt, "@identifier", axis.getIdentifier());
                    List<String> keys = axis.getKeys();
                    for (int h = 0; h < keys.size(); ++h) {
                        String key = keys.get(h);
                        dom.setElementValue(axisElt, "AvailableKeys/+Key", key);
                    }
                }
            }
            this.writeCRSList(dom, descElt, desc);
            this.writeFormatList(dom, descElt, desc);
        }
        return rootElt;
    }

    protected void writeCRSList(DOMHelper dom, Element layerElt, CoverageDescription desc) {
        int numElts = desc.getCrsList().size();
        for (int i = 0; i < numElts; ++i) {
            String crs = desc.getCrsList().get(i);
            dom.setElementValue(layerElt, "+SupportedCRS", crs);
        }
    }

    protected void writeFormatList(DOMHelper dom, Element layerElt, CoverageDescription desc) {
        int numElts = desc.getFormatList().size();
        for (int i = 0; i < numElts; ++i) {
            String format = desc.getFormatList().get(i);
            dom.setElementValue(layerElt, "+SupportedFormat", format);
        }
    }
}

