/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import java.io.IOException;
import java.io.InputStream;
import org.vast.cdm.common.DataHandler;
import org.vast.ogc.OGCException;
import org.vast.ogc.OGCExceptionReader;
import org.vast.swe.SWEFilter;
import org.vast.swe.SWEReader;
import org.vast.swe.SWEUtils;
import org.vast.swe.URIStreamHandler;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;

public class CoverageReader
extends SWEReader {
    SWEUtils sweUtils = new SWEUtils("2.0");
    String resultUri;
    SWEFilter streamFilter;

    public void parse(InputStream inputStream, DataHandler handler) throws IOException {
        try {
            this.dataHandler = handler;
            this.streamFilter = new SWEFilter(inputStream);
            this.streamFilter.setDataElementName("value");
            DOMHelper dom = new DOMHelper((InputStream)this.streamFilter, false);
            OGCExceptionReader.checkException((DOMHelper)dom);
            Element defElt = dom.getElement("result/Data/definition/DataDefinition");
            Element dataElt = dom.getElement(defElt, "dataComponents/*");
            Element encElt = dom.getElement(defElt, "encoding/*");
            this.dataComponents = this.sweUtils.readComponent(dom, dataElt);
            this.dataEncoding = this.sweUtils.readEncoding(dom, encElt);
            this.resultUri = dom.getAttributeValue("result/data/value/externalLink");
        }
        catch (DOMHelperException e) {
            throw new XMLReaderException("Error while parsing Coverage XML", (Exception)((Object)e));
        }
        catch (OGCException e) {
            throw new XMLReaderException(e.getMessage());
        }
    }

    public InputStream getDataStream() throws IOException {
        if (this.resultUri != null) {
            try {
                this.streamFilter.startReadingData();
                this.streamFilter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return URIStreamHandler.openStream((String)this.resultUri);
        }
        this.streamFilter.startReadingData();
        return this.streamFilter;
    }
}

