/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import java.util.Map;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.wcs.DescribeCoverageRequest;
import org.vast.ows.wcs.WCSException;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescribeCoverageReaderV11
extends AbstractRequestReader<DescribeCoverageRequest> {
    @Override
    public DescribeCoverageRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        DescribeCoverageRequest request = new DescribeCoverageRequest();
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            try {
                if (argName.equalsIgnoreCase("SERVICE")) {
                    request.setService(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("VERSION")) {
                    request.setVersion(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("REQUEST")) {
                    request.setOperation(argValue);
                    continue;
                }
                if (!argName.equalsIgnoreCase("IDENTIFIERS")) continue;
                String[] coverageList = argValue.split(",");
                for (int i = 0; i < coverageList.length; ++i) {
                    request.getCoverages().add(coverageList[i]);
                }
            }
            catch (Exception e) {
                report.add(new WCSException("InvalidParameterValue", argName.toUpperCase(), argValue, null));
            }
        }
        report.process();
        this.checkParameters(request, report);
        return request;
    }

    @Override
    public DescribeCoverageRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        DescribeCoverageRequest request = new DescribeCoverageRequest();
        DescribeCoverageReaderV11.readCommonXML(dom, requestElt, request);
        NodeList idElts = dom.getElements(requestElt, "Identifier");
        for (int i = 0; i < idElts.getLength(); ++i) {
            String val = dom.getElementValue((Element)idElts.item(i));
            request.getCoverages().add(val);
        }
        this.checkParameters(request, report);
        report.process();
        return request;
    }

    protected void checkParameters(DescribeCoverageRequest request, OWSExceptionReport report) throws OWSException {
        AbstractRequestReader.checkParameters(request, report, "WCS");
        if (request.getCoverages().isEmpty()) {
            report.add(new OWSException("MissingParameterValue", "identifiers"));
        }
        report.process();
    }
}

