/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.wcs.DescribeCoverageRequest;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class DescribeCoverageWriterV11
extends AbstractRequestWriter<DescribeCoverageRequest> {
    @Override
    public String buildURLQuery(DescribeCoverageRequest request) throws OWSException {
        StringBuilder urlBuff = new StringBuilder(request.getGetServer());
        this.addCommonArgs(urlBuff, (OWSRequest)request);
        if (!request.getCoverages().isEmpty()) {
            urlBuff.append("&IDENTIFIERS=");
            int listSize = request.getCoverages().size();
            for (int i = 0; i < listSize; ++i) {
                urlBuff.append(request.getCoverages().get(i));
                if (i >= listSize - 1) continue;
                urlBuff.append(",");
            }
        }
        String url = urlBuff.toString();
        url = url.replaceAll(" ", "%20");
        return url;
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, DescribeCoverageRequest request) throws OWSException {
        dom.addUserPrefix("_NIL_", OGCRegistry.getNamespaceURI((String)"WCS", (String)request.getVersion()));
        Element rootElt = dom.createElement("DescribeCoverage");
        this.addCommonXML(dom, rootElt, request);
        for (int i = 0; i < request.getCoverages().size(); ++i) {
            dom.setElementValue(rootElt, "Identifier", request.getCoverages().get(i));
        }
        return rootElt;
    }
}

