/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import java.text.ParseException;
import java.util.Map;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.OWSCommonReaderV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.wcs.AxisSubset;
import org.vast.ows.wcs.FieldSubset;
import org.vast.ows.wcs.GetCoverageRequest;
import org.vast.ows.wcs.WCSCommonReaderV11;
import org.vast.ows.wcs.WCSException;
import org.vast.ows.wcs.WCSRectifiedGridCrs;
import org.vast.util.Bbox;
import org.vast.util.TimeExtent;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetCoverageReaderV11
extends AbstractRequestReader<GetCoverageRequest> {
    protected WCSCommonReaderV11 wcsReader = new WCSCommonReaderV11();
    protected OWSCommonReaderV11 owsReader = new OWSCommonReaderV11();

    @Override
    public GetCoverageRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetCoverageRequest request = new GetCoverageRequest();
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            try {
                if (argName.equalsIgnoreCase("service")) {
                    request.setService(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("version")) {
                    request.setVersion(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("request")) {
                    request.setOperation(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("identifier")) {
                    request.setCoverage(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("TimeSequence")) {
                    String[] timeList = argValue.split(",");
                    for (int i = 0; i < timeList.length; ++i) {
                        TimeExtent newTime = this.parseTimeArg(timeList[i]);
                        request.getTimes().add(newTime);
                    }
                    continue;
                }
                if (argName.equalsIgnoreCase("BoundingBox")) {
                    Bbox bbox = this.parseBboxArg(argValue);
                    request.setBbox(bbox);
                    continue;
                }
                if (argName.equalsIgnoreCase("RangeSubset")) {
                    this.parseRangeSubset(request, argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("GridBaseCRS")) {
                    request.getGridCrs().setBaseCrs(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("GridCS")) {
                    request.getGridCrs().setGridCs(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("GridType")) {
                    request.getGridCrs().setGridType(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("GridOrigin")) {
                    double[] origin = this.parseVector(argValue);
                    request.getGridCrs().setGridDimension(origin.length);
                    request.getGridCrs().setGridOrigin(origin);
                    continue;
                }
                if (argName.equalsIgnoreCase("GridOffsets")) {
                    double[][] vectors = WCSCommonReaderV11.parseGridOffsets(argValue);
                    request.getGridCrs().setGridOffsets(vectors);
                    continue;
                }
                if (argName.equalsIgnoreCase("format")) {
                    request.setFormat(argValue);
                    continue;
                }
                this.addKVPExtension(argName, argValue, request);
            }
            catch (Exception e) {
                report.add(new WCSException("InvalidParameterValue", argName.toUpperCase(), argValue, null));
            }
        }
        report.process();
        this.checkParameters(request, report);
        return request;
    }

    protected void parseRangeSubset(GetCoverageRequest query, String kvpToken) {
    }

    @Override
    public GetCoverageRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetCoverageRequest request = new GetCoverageRequest();
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        GetCoverageReaderV11.readCommonXML(dom, requestElt, request);
        String covID = dom.getElementValue(requestElt, "Identifier");
        request.setCoverage(covID);
        Element domainElt = dom.getElement(requestElt, "DomainSubset");
        Element bboxElt = dom.getElement(domainElt, "ows:BoundingBox");
        if (bboxElt != null) {
            Bbox bbox = this.owsReader.readBbox(dom, bboxElt);
            request.setBbox(bbox);
        }
        NodeList timeElts = dom.getElements(domainElt, "TemporalSubset/*");
        for (int i = 0; i < timeElts.getLength(); ++i) {
            Element timeElt = (Element)timeElts.item(i);
            if (timeElt.getLocalName().equals("timePosition")) {
                try {
                    double time = this.timeFormat.parseIso(dom.getElementValue(timeElt));
                    request.getTimes().add(new TimeExtent(time));
                }
                catch (ParseException e) {
                    report.add(new WCSException("Invalid XML Request: Invalid Time Position"));
                }
                continue;
            }
            if (timeElt.getLocalName().equals("TimePeriod")) {
                TimeExtent timeRange = new TimeExtent();
                String beginPos = dom.getElementValue(timeElt, "BeginPosition");
                String endPos = dom.getElementValue(timeElt, "EndPosition");
                try {
                    double begin = this.timeFormat.parseIso(beginPos);
                    timeRange.setStartTime(begin);
                }
                catch (ParseException e) {
                    throw new WCSException("Invalid XML Request: Invalid Value for  BeginPosition: " + beginPos);
                }
                try {
                    double end = this.timeFormat.parseIso(endPos);
                    timeRange.setStopTime(end);
                }
                catch (ParseException e) {
                    throw new WCSException("Invalid XML Request: Invalid Value for  EndPosition: " + endPos);
                }
                String timeRes = dom.getElementValue(timeElt, "TimeResolution");
                if (timeRes != null) {
                    double step = 0.0;
                    try {
                        step = timeRes.contains("P") ? this.timeFormat.parseIsoPeriod(timeRes) : Double.parseDouble(timeRes);
                        timeRange.setTimeStep(step);
                    }
                    catch (Exception e) {
                        throw new WCSException("Invalid XML Request: Invalid Value for  TimeResolution: " + timeRes);
                    }
                }
                request.getTimes().add(timeRange);
                continue;
            }
            throw new WCSException("Invalid XML Request: Invalid Time Subset: " + timeElt.getLocalName());
        }
        NodeList fieldElts = dom.getElements(requestElt, "RangeSubset/FieldSubset");
        for (int j = 0; j < fieldElts.getLength(); ++j) {
            Element fieldElt = (Element)fieldElts.item(j);
            FieldSubset field = new FieldSubset();
            request.getFieldSubsets().add(field);
            field.setIdentifier(dom.getElementValue(fieldElt, "Identifier"));
            String interpolationMethod = dom.getElementValue(fieldElt, "InterpolationType");
            if (interpolationMethod != null) {
                field.setInterpolationMethod(interpolationMethod);
            }
            NodeList axisElts = dom.getElements(fieldElt, "AxisSubset");
            for (int k = 0; k < axisElts.getLength(); ++k) {
                Element axisElt = (Element)axisElts.item(k);
                AxisSubset axisSubset = new AxisSubset();
                field.getAxisSubsets().add(axisSubset);
                axisSubset.setIdentifier(dom.getElementValue(axisElt, "Identifier"));
                NodeList keyElts = dom.getElements(axisElt, "Key");
                for (int h = 0; h < keyElts.getLength(); ++h) {
                    Element keyElt = (Element)keyElts.item(h);
                    String key = dom.getElementValue(keyElt);
                    axisSubset.getKeys().add(key);
                }
            }
        }
        Element outputElt = dom.getElement(requestElt, "Output");
        String format = dom.getAttributeValue(outputElt, "@format");
        request.setFormat(format);
        String store = dom.getAttributeValue(outputElt, "@store");
        if (store != null && store.equalsIgnoreCase("true")) {
            request.setStore(true);
        } else {
            request.setStore(false);
        }
        Element gridElt = dom.getElement(outputElt, "GridCRS");
        if (gridElt != null) {
            WCSRectifiedGridCrs gridCrs = new WCSRectifiedGridCrs();
            this.wcsReader.readGridCRS(dom, gridElt, gridCrs);
        }
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(GetCoverageRequest request, OWSExceptionReport report) throws OWSException {
        AbstractRequestReader.checkParameters(request, report, "WCS");
        if (request.getCoverage() == null) {
            report.add(new OWSException("MissingParameterValue", "Identifier"));
        }
        if (request.getBbox() == null && request.getTime() == null) {
            report.add(new OWSException("MissingParameterValue", "TimeSequence/BoundingBox"));
        }
        if (request.getBbox() != null) {
            if (request.getBbox().getCrs() == null) {
                report.add(new OWSException("MissingParameterValue", "CRS"));
            } else if (request.getGridCrs().getBaseCrs() == null && request.getBbox() != null) {
                request.getGridCrs().setBaseCrs(request.getBbox().getCrs());
            }
        }
        if (request.getFormat() == null) {
            report.add(new OWSException("MissingParameterValue", "Format"));
        }
        report.process();
    }
}

