/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import java.text.ParseException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.wcs.DimensionSubset;
import org.vast.ows.wcs.GetCoverageRequest;
import org.vast.ows.wcs.WCSException;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCoverageReaderV20
extends AbstractRequestReader<GetCoverageRequest> {
    @Override
    public GetCoverageRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetCoverageRequest request = new GetCoverageRequest();
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            try {
                if (argName.equalsIgnoreCase("service")) {
                    request.setService(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("version")) {
                    request.setVersion(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("request")) {
                    request.setOperation(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("coverageId")) {
                    request.setCoverage(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("subset")) {
                    request.getDimensionSubsets().add(this.parseKVPDimensionSubset(argValue));
                    continue;
                }
                if (argName.equalsIgnoreCase("format")) {
                    request.setFormat(argValue);
                    continue;
                }
                this.addKVPExtension(argName, argValue, request);
            }
            catch (Exception e) {
                report.add(new WCSException("InvalidParameterValue", argName.toUpperCase(), argValue, null));
            }
        }
        report.process();
        this.checkParameters(request, report);
        return request;
    }

    protected DimensionSubset parseKVPDimensionSubset(String kvpToken) throws ParseException {
        DimensionSubset subset = new DimensionSubset();
        Matcher m = Pattern.compile("^(.+?)(,(.+?))?\\((.+?)\\)$").matcher(kvpToken);
        if (m.matches()) {
            subset.setAxis(m.group(1));
            subset.setCrs(m.group(3));
            String[] bounds = m.group(4).split(",");
            subset.setMin(this.parseNumberOrTime(bounds[0]));
            if (bounds.length > 1) {
                subset.setMax(this.parseNumberOrTime(bounds[1]));
            } else {
                subset.setMax(this.parseNumberOrTime(bounds[0]));
            }
        } else {
            throw new IllegalArgumentException();
        }
        return subset;
    }

    @Override
    public GetCoverageRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        GetCoverageRequest request = new GetCoverageRequest();
        GetCoverageReaderV20.readCommonXML(dom, requestElt, request);
        String covID = dom.getElementValue(requestElt, "CoverageId");
        request.setCoverage(covID);
        NodeList dimSubsetElts = dom.getChildElements((Node)requestElt);
        for (int i = 0; i < dimSubsetElts.getLength(); ++i) {
            Element dimSubsetElt = (Element)dimSubsetElts.item(i);
            String eltName = dimSubsetElt.getLocalName();
            if (!eltName.startsWith("Dimension")) continue;
            DimensionSubset subset = new DimensionSubset();
            String axisName = dom.getElementValue(dimSubsetElt, "Dimension");
            subset.setAxis(axisName);
            try {
                if (eltName.equals("DimensionTrim")) {
                    double low = this.parseNumberOrTime(dom.getElementValue(dimSubsetElt, "TrimLow"));
                    subset.setMin(low);
                    double high = this.parseNumberOrTime(dom.getElementValue(dimSubsetElt, "TrimHigh"));
                    subset.setMax(high);
                } else {
                    if (!eltName.equals("DimensionSlice")) continue;
                    double val = this.parseNumberOrTime(dom.getElementValue(dimSubsetElt, "SlicePoint"));
                    subset.setMin(val);
                    subset.setMax(val);
                }
            }
            catch (Exception e) {
                report.add(new WCSException("InvalidParameterValue", "DimensionSubset"));
            }
            request.getDimensionSubsets().add(subset);
        }
        this.checkParameters(request, report);
        return request;
    }

    protected double parseNumberOrTime(String text) throws ParseException {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            if (text.startsWith("\"")) {
                text.replace("\"", "");
            }
            return this.timeFormat.parseIso(text);
        }
    }

    protected void checkParameters(GetCoverageRequest request, OWSExceptionReport report) throws OWSException {
        AbstractRequestReader.checkParameters(request, report, "WCS");
        if (request.getCoverage() == null) {
            report.add(new OWSException("MissingParameterValue", "CoverageId"));
        }
        report.process();
    }
}

