/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import java.util.ArrayList;
import java.util.List;
import org.vast.ows.OWSRequest;
import org.vast.ows.wcs.DimensionSubset;
import org.vast.ows.wcs.FieldSubset;
import org.vast.ows.wcs.WCSRectifiedGridCrs;
import org.vast.util.Bbox;
import org.vast.util.TimeExtent;

public class GetCoverageRequest
extends OWSRequest {
    protected String coverage;
    protected String format;
    protected List<DimensionSubset> dimensionSubsets;
    protected List<FieldSubset> fieldSubsets;
    protected int width;
    protected int height;
    protected int depth;
    protected int skipX;
    protected int skipY;
    protected int skipZ;
    protected WCSRectifiedGridCrs gridCrs;
    protected boolean store;
    protected boolean useResolution;

    public GetCoverageRequest() {
        this.service = "WCS";
        this.operation = "GetCoverage";
        this.dimensionSubsets = new ArrayList<DimensionSubset>();
        this.fieldSubsets = new ArrayList<FieldSubset>();
        this.gridCrs = new WCSRectifiedGridCrs();
        this.depth = -1;
        this.height = -1;
        this.width = -1;
        this.useResolution = false;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public Bbox getBbox() {
        Bbox bbox = new Bbox();
        for (DimensionSubset range : this.dimensionSubsets) {
            String axisName = range.getAxis();
            if (axisName.equals("X")) {
                bbox.setMinX(range.getMin());
                bbox.setMaxX(range.getMax());
                bbox.setCrs(range.getCrs());
                continue;
            }
            if (axisName.equals("Y")) {
                bbox.setMinY(range.getMin());
                bbox.setMaxY(range.getMax());
                continue;
            }
            if (!axisName.equals("Z")) continue;
            bbox.setMinZ(range.getMin());
            bbox.setMaxZ(range.getMax());
        }
        if (bbox.isNull()) {
            return null;
        }
        return bbox;
    }

    public void setBbox(Bbox bbox) {
        String crs = bbox.getCrs();
        if (!Double.isNaN(bbox.getMinX())) {
            this.dimensionSubsets.add(new DimensionSubset(crs, "X", bbox.getMinX(), bbox.getMaxX()));
        }
        if (!Double.isNaN(bbox.getMinY())) {
            this.dimensionSubsets.add(new DimensionSubset(crs, "Y", bbox.getMinY(), bbox.getMaxY()));
        }
        if (!Double.isNaN(bbox.getMinZ())) {
            this.dimensionSubsets.add(new DimensionSubset(crs, "Z", bbox.getMinZ(), bbox.getMaxZ()));
        }
    }

    public TimeExtent getTime() {
        for (DimensionSubset range : this.dimensionSubsets) {
            String axisName = range.getAxis();
            if (!axisName.equals("T")) continue;
            TimeExtent timeInfo = new TimeExtent();
            timeInfo.setStartTime(range.getMin());
            timeInfo.setStopTime(range.getMax());
            return timeInfo;
        }
        return null;
    }

    public void setTime(TimeExtent time) {
        if (!time.isNull()) {
            this.dimensionSubsets.add(new DimensionSubset("T", time.getStartTime(), time.getStopTime()));
        }
    }

    public List<TimeExtent> getTimes() {
        ArrayList<TimeExtent> times = new ArrayList<TimeExtent>();
        for (DimensionSubset range : this.dimensionSubsets) {
            String axisName = range.getAxis();
            if (!axisName.equals("T")) continue;
            TimeExtent timeInfo = new TimeExtent();
            timeInfo.setStartTime(range.getMin());
            timeInfo.setStopTime(range.getMax());
            times.add(timeInfo);
        }
        return times;
    }

    public List<DimensionSubset> getDimensionSubsets() {
        return this.dimensionSubsets;
    }

    public List<FieldSubset> getFieldSubsets() {
        return this.fieldSubsets;
    }

    public void setGridCrs(WCSRectifiedGridCrs gridCrs) {
        this.gridCrs = gridCrs;
    }

    public WCSRectifiedGridCrs getGridCrs() {
        return this.gridCrs;
    }

    public double getResX() {
        if (this.useResolution && this.gridCrs.gridOffsets != null && this.gridCrs.gridDimension > 0) {
            return this.gridCrs.gridOffsets[0][0];
        }
        return Double.NaN;
    }

    public void setResX(double resX) {
        if (this.gridCrs.gridOffsets != null && this.gridCrs.gridDimension > 0) {
            this.gridCrs.gridOffsets[0][0] = resX;
            this.useResolution = true;
        }
    }

    public double getResY() {
        if (this.useResolution && this.gridCrs.gridOffsets != null && this.gridCrs.gridDimension > 1) {
            return this.gridCrs.gridOffsets[1][1];
        }
        return Double.NaN;
    }

    public void setResY(double resY) {
        if (this.gridCrs.gridOffsets != null && this.gridCrs.gridDimension > 1) {
            this.gridCrs.gridOffsets[1][1] = resY;
            this.useResolution = true;
        }
    }

    public double getResZ() {
        if (this.useResolution && this.gridCrs.gridOffsets != null && this.gridCrs.gridDimension > 2) {
            return this.gridCrs.gridOffsets[2][2];
        }
        return Double.NaN;
    }

    public void setResZ(double resZ) {
        if (this.gridCrs.gridOffsets != null && this.gridCrs.gridDimension > 2) {
            this.gridCrs.gridOffsets[2][2] = resZ;
            this.useResolution = true;
        }
    }

    public int getSkipX() {
        return this.skipX;
    }

    public void setSkipX(int skipX) {
        this.skipX = skipX;
    }

    public int getSkipY() {
        return this.skipY;
    }

    public void setSkipY(int skipY) {
        this.skipY = skipY;
    }

    public int getSkipZ() {
        return this.skipZ;
    }

    public void setSkipZ(int skipZ) {
        this.skipZ = skipZ;
    }

    public int getWidth() {
        if (!this.useResolution) {
            return this.width;
        }
        return -1;
    }

    public void setWidth(int width) {
        this.width = width;
        this.useResolution = false;
    }

    public int getHeight() {
        if (!this.useResolution) {
            return this.height;
        }
        return -1;
    }

    public void setHeight(int height) {
        this.height = height;
        this.useResolution = false;
    }

    public int getDepth() {
        if (!this.useResolution) {
            return this.depth;
        }
        return -1;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        this.useResolution = false;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean getStore() {
        return this.store;
    }

    public void setStore(boolean store) {
        this.store = store;
    }

    public boolean isUseResolution() {
        return this.useResolution;
    }

    public void setUseResolution(boolean useResolution) {
        this.useResolution = useResolution;
    }
}

