/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.OWSCommonWriterV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.wcs.AxisSubset;
import org.vast.ows.wcs.FieldSubset;
import org.vast.ows.wcs.GetCoverageRequest;
import org.vast.ows.wcs.WCSCommonWriterV11;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetCoverageWriterV11
extends AbstractRequestWriter<GetCoverageRequest> {
    protected WCSCommonWriterV11 wcsWriter = new WCSCommonWriterV11();
    protected OWSCommonWriterV11 owsWriter = new OWSCommonWriterV11();

    @Override
    public String buildURLQuery(GetCoverageRequest request) throws OWSException {
        StringBuilder urlBuff = new StringBuilder(request.getGetServer());
        this.addCommonArgs(urlBuff, (OWSRequest)request);
        urlBuff.append("&IDENTIFIER=" + request.getCoverage());
        if (request.getTime() != null) {
            urlBuff.append("&TIME=");
            this.writeTimeArgument(urlBuff, request.getTime());
        }
        if (request.getBbox() != null) {
            urlBuff.append("&CRS=" + request.getBbox().getCrs());
            urlBuff.append("&BBOX=");
            this.writeBboxArgument(urlBuff, request.getBbox());
            if (request.isUseResolution()) {
                urlBuff.append("&RESX=" + request.getResX());
                urlBuff.append("&RESY=" + request.getResY());
                if (request.getResZ() > 0.0) {
                    urlBuff.append("&RESZ=" + request.getResZ());
                }
            } else {
                urlBuff.append("&WIDTH=" + request.getWidth());
                urlBuff.append("&HEIGHT=" + request.getHeight());
                if (request.getDepth() > 0) {
                    urlBuff.append("&DEPTH=" + request.getDepth());
                }
            }
        }
        if (request.getGridCrs() != null) {
            urlBuff.append("&RESPONSE_CRS=" + request.getGridCrs().getBaseCrs());
        }
        urlBuff.append("&FORMAT=" + request.getFormat());
        if (request.getExceptionType() != null) {
            urlBuff.append("&EXCEPTIONS=" + request.getExceptionType());
        }
        this.writeKVPExtensions(urlBuff, request);
        String url = urlBuff.toString();
        url = url.replaceAll(" ", "%20");
        return url;
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, GetCoverageRequest request) throws OWSException {
        boolean store;
        String format;
        dom.addUserPrefix("_NIL_", OGCRegistry.getNamespaceURI((String)"WCS", (String)request.getVersion()));
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        Element rootElt = dom.createElement("GetCoverage");
        this.addCommonXML(dom, rootElt, request);
        dom.setElementValue(rootElt, "ows:Identifier", request.getCoverage());
        Element domainElt = dom.addElement((Node)rootElt, "DomainSubset");
        Element bboxElt = this.owsWriter.buildBbox(dom, request.getBbox());
        domainElt.appendChild(bboxElt);
        for (int i = 0; i < request.getFieldSubsets().size(); ++i) {
            Element fieldElt = dom.addElement((Node)rootElt, "RangeSubset/+FieldSubset");
            FieldSubset field = request.getFieldSubsets().get(i);
            dom.setElementValue(fieldElt, "ows:Identifier", field.getIdentifier());
            for (int j = 0; j < request.getFieldSubsets().size(); ++j) {
                AxisSubset axis = field.getAxisSubsets().get(j);
                Element axisElt = dom.addElement((Node)fieldElt, "+AxisSubset");
                dom.setElementValue(axisElt, "Identifier", axis.getIdentifier());
                for (int k = 0; k < axis.getKeys().size(); ++k) {
                    dom.setElementValue(axisElt, "+Key", axis.getKeys().get(k));
                }
            }
            if (field.getInterpolationMethod() == null) continue;
            dom.setElementValue(fieldElt, "interpolationType", field.getInterpolationMethod());
        }
        Element outputElt = dom.addElement((Node)rootElt, "Output");
        if (request.getGridCrs() != null) {
            String id = "REQUEST_GRID_CRS";
            Element gridCrsElt = this.wcsWriter.buildGridCRS(dom, request.getGridCrs(), id);
            outputElt.appendChild(gridCrsElt);
        }
        if ((format = request.getFormat()) != null) {
            dom.setAttributeValue(outputElt, "format", request.getFormat());
        }
        if (store = request.getStore()) {
            dom.setAttributeValue(outputElt, "store", Boolean.toString(store));
        }
        return rootElt;
    }
}

