/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import org.vast.ows.OWSCapabilitiesReaderV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.wcs.WCSLayerCapabilities;
import org.vast.util.Bbox;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WCSCapabilitiesReaderV11
extends OWSCapabilitiesReaderV11 {
    @Override
    protected void readContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        NodeList layers = dom.getElements(capsElt, "Contents/CoverageSummary");
        int numLayers = layers.getLength();
        for (int i = 0; i < numLayers; ++i) {
            Element layerCapElt = (Element)layers.item(i);
            WCSLayerCapabilities layerCap = new WCSLayerCapabilities();
            layerCap.setParent(serviceCaps);
            this.owsReader.readIdentification(dom, layerCapElt, layerCap);
            this.read2DBboxList(layerCap, dom, layerCapElt);
            this.readCRSList(layerCap, dom, layerCapElt);
            this.readFormatList(layerCap, dom, layerCapElt);
            serviceCaps.getLayers().add(layerCap);
        }
    }

    protected void read2DBboxList(WCSLayerCapabilities layerCap, DOMHelper dom, Element layerElt) {
        NodeList bboxElts = dom.getElements(layerElt, "WGS84BoundingBox");
        int numElts = bboxElts.getLength();
        for (int i = 0; i < numElts; ++i) {
            Element bboxElt = (Element)bboxElts.item(i);
            String[] lowerCoords = dom.getElementValue(bboxElt, "LowerCorner").split(" ");
            String[] upperCoords = dom.getElementValue(bboxElt, "UpperCorner").split(" ");
            String crs = dom.getAttributeValue(bboxElt, "@crs");
            Bbox bbox = new Bbox();
            double minX = Double.parseDouble(lowerCoords[0]);
            double minY = Double.parseDouble(lowerCoords[1]);
            double maxX = Double.parseDouble(upperCoords[0]);
            double maxY = Double.parseDouble(upperCoords[1]);
            bbox.setMinX(minX);
            bbox.setMinY(minY);
            bbox.setMaxX(maxX);
            bbox.setMaxY(maxY);
            bbox.setCrs(crs);
            layerCap.getBboxList().add(bbox);
        }
    }

    protected void readFormatList(WCSLayerCapabilities layerCap, DOMHelper dom, Element layerElt) {
        NodeList formatElts = dom.getElements(layerElt, "SupportedFormat");
        int numElts = formatElts.getLength();
        for (int i = 0; i < numElts; ++i) {
            Element formatElt = (Element)formatElts.item(i);
            String formatName = dom.getElementValue(formatElt);
            layerCap.getFormatList().add(formatName);
        }
    }

    protected void readCRSList(WCSLayerCapabilities layerCap, DOMHelper dom, Element layerElt) {
        NodeList crsElts = dom.getElements(layerElt, "SupportedCRS");
        int numElts = crsElts.getLength();
        for (int i = 0; i < numElts; ++i) {
            Element crsElt = (Element)crsElts.item(i);
            String crsName = dom.getElementValue(crsElt);
            layerCap.getCrsList().add(crsName);
        }
    }
}

