/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSCapabilitiesWriterV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.wcs.WCSLayerCapabilities;
import org.vast.util.Bbox;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WCSCapabilitiesWriterV11
extends OWSCapabilitiesWriterV11 {
    @Override
    public Element buildXMLResponse(DOMHelper dom, OWSServiceCapabilities caps, String version) throws OWSException {
        dom.addUserPrefix("_NIL_", OGCRegistry.getNamespaceURI((String)"WCS", (String)version));
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS", (String)"1.1"));
        dom.addUserPrefix("xlink", OGCRegistry.getNamespaceURI((String)"XLINK"));
        Element capsElt = dom.createElement("Capabilities");
        this.writeRootAttributes(dom, capsElt, caps, version);
        this.writeServiceIdentification(dom, capsElt, caps);
        this.writeServiceProvider(dom, capsElt, caps.getServiceProvider());
        this.writeOperationsMetadata(dom, capsElt, caps);
        this.writeContents(dom, capsElt, caps, version);
        return capsElt;
    }

    @Override
    protected void writeContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities caps, String version) throws OWSException {
        Element contentsElt = dom.addElement((Node)capsElt, "Contents");
        for (int i = 0; i < caps.getLayers().size(); ++i) {
            WCSLayerCapabilities layerCaps = (WCSLayerCapabilities)caps.getLayers().get(i);
            Element summaryElt = dom.addElement((Node)contentsElt, "+CoverageSummary");
            this.writeIdentification(dom, summaryElt, layerCaps);
            this.writeBboxList(dom, summaryElt, layerCaps);
            this.writeCRSList(dom, summaryElt, layerCaps);
            this.writeFormatList(dom, summaryElt, layerCaps);
            String id = layerCaps.getIdentifier();
            dom.setElementValue(summaryElt, "Identifier", id);
        }
    }

    protected void writeBboxList(DOMHelper dom, Element layerElt, WCSLayerCapabilities layerCaps) {
        int numElts = layerCaps.getBboxList().size();
        for (int i = 0; i < numElts; ++i) {
            Bbox bbox = layerCaps.getBboxList().get(i);
            Element bboxElt = dom.addElement((Node)layerElt, "+ows:WGS84BoundingBox");
            dom.setElementValue(bboxElt, "ows:LowerCorner", bbox.getMinX() + " " + bbox.getMinY());
            dom.setElementValue(bboxElt, "ows:UpperCorner", bbox.getMaxX() + " " + bbox.getMaxY());
        }
    }

    protected void writeCRSList(DOMHelper dom, Element layerElt, WCSLayerCapabilities layerCaps) {
        int numElts = layerCaps.getCrsList().size();
        for (int i = 0; i < numElts; ++i) {
            String crs = layerCaps.getCrsList().get(i);
            dom.setElementValue(layerElt, "+SupportedCRS", crs);
        }
    }

    protected void writeFormatList(DOMHelper dom, Element layerElt, WCSLayerCapabilities layerCaps) {
        int numElts = layerCaps.getFormatList().size();
        for (int i = 0; i < numElts; ++i) {
            String format = layerCaps.getFormatList().get(i);
            dom.setElementValue(layerElt, "+SupportedFormat", format);
        }
    }
}

