/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import org.vast.ows.OWSCommonUtils;
import org.vast.ows.OWSException;
import org.vast.ows.wcs.WCSRectifiedGridCrs;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class WCSCommonReaderV11
extends OWSCommonUtils {
    public void readGridCRS(DOMHelper dom, Element gridElt, WCSRectifiedGridCrs gridCrs) throws OWSException {
        String gridOffsets;
        String gridOrigin;
        String gridCs;
        String responseCrs = dom.getElementValue(gridElt, "GridBaseCRS");
        gridCrs.setBaseCrs(responseCrs);
        String gridType = dom.getElementValue(gridElt, "GridType");
        if (gridType != null) {
            gridCrs.setGridType(gridType);
        }
        if ((gridCs = dom.getElementValue(gridElt, "GridCS")) != null) {
            gridCrs.setGridCs(gridCs);
        }
        if ((gridOrigin = dom.getElementValue(gridElt, "GridOrigin")) != null) {
            double[] vecOrig = this.parseVector(gridOrigin);
            gridCrs.setGridDimension(vecOrig.length);
            gridCrs.setGridOrigin(vecOrig);
        }
        if ((gridOffsets = dom.getElementValue(gridElt, "GridOffsets")) != null) {
            double[][] vectors = WCSCommonReaderV11.parseGridOffsets(gridOffsets);
            gridCrs.setGridOffsets(vectors);
        }
    }

    protected static double[][] parseGridOffsets(String vectorText) throws OWSException {
        try {
            String[] elts = vectorText.trim().split("[ ,]");
            int gridDim = (int)Math.sqrt(elts.length);
            double[][] vec = new double[gridDim][gridDim];
            int index = 0;
            for (int i = 0; i < gridDim; ++i) {
                for (int j = 0; j < gridDim; ++j) {
                    vec[i][j] = Double.parseDouble(elts[index++]);
                }
            }
            return vec;
        }
        catch (NumberFormatException e) {
            throw new OWSException("Invalid Grid Offsets: " + vectorText, e);
        }
    }
}

