/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.wcs.WCSRectifiedGridCrs;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class WCSCommonWriterV11 {
    public Element buildGridCRS(DOMHelper dom, WCSRectifiedGridCrs gridCrs, String id) throws OWSException {
        dom.addUserPrefix("gml", OGCRegistry.getNamespaceURI((String)"GML"));
        Element gridElt = dom.createElement("GridCRS");
        dom.setElementValue(gridElt, "gml:srsName", id);
        dom.setElementValue(gridElt, "GridBaseCRS", gridCrs.getBaseCrs());
        dom.setElementValue(gridElt, "GridType", gridCrs.getGridType());
        double[] origin = gridCrs.getGridOrigin();
        String originVal = origin[0] + " " + origin[1];
        dom.setElementValue(gridElt, "GridOrigin", originVal);
        double[][] offsets = gridCrs.getGridOffsets();
        String offsetText = this.getGridOffsets(offsets);
        dom.setElementValue(gridElt, "GridOffsets", offsetText);
        dom.setElementValue(gridElt, "GridCS", gridCrs.getGridCs());
        return gridElt;
    }

    protected String getGridOffsets(double[][] offsets) throws OWSException {
        StringBuffer offsetBuf = new StringBuffer();
        for (int u = 0; u < offsets.length; ++u) {
            for (int v = 0; v < offsets[0].length; ++v) {
                offsetBuf.append(offsets[u][v] + " ");
            }
        }
        String offsetVal = offsetBuf.toString().trim();
        return offsetVal;
    }
}

