/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import org.vast.ows.OWSException;

public class WCSException
extends OWSException {
    static final long serialVersionUID = -1363920464307597462L;
    public static final String invalid_format_code = "InvalidFormat";
    public static final String invalid_format_text = "Invalid Format: ";
    public static final String invalid_coverage_code = "CoverageNotDefined";
    public static final String invalid_coverage_text = "Invalid Coverage ID: ";

    public WCSException(String message) {
        super(message);
    }

    public WCSException(Exception e) {
        super(e);
    }

    public WCSException(String message, Exception e) {
        super(message, e);
    }

    public WCSException(String code, String locator) {
        this(code, locator, (String)null, (String)null);
    }

    public WCSException(String code, String locator, String badValue, String message) {
        super(code, locator, badValue, message);
        if (code == invalid_coverage_code) {
            locator = "Coverage";
        } else if (code == invalid_format_code) {
            locator = "Format";
        }
    }

    @Override
    public String getMessage() {
        if (this.code == invalid_coverage_code) {
            return invalid_coverage_text + (this.badValue == null ? "" : this.badValue);
        }
        if (this.code == invalid_format_code) {
            return invalid_format_text + (this.badValue == null ? "" : this.badValue);
        }
        return super.getMessage();
    }
}

