/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.opengis.swe.v20.BlockComponent;
import net.opengis.swe.v20.DataArray;
import org.vast.cdm.common.DataHandler;
import org.vast.data.DataArrayImpl;
import org.vast.ogc.OGCException;
import org.vast.ogc.OGCExceptionReader;
import org.vast.swe.SWEFilter;
import org.vast.swe.SWEReader;
import org.vast.swe.SWEUtils;
import org.vast.swe.URIStreamHandler;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.vast.xml.XMLReaderException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WCSResponseReader
extends SWEReader {
    protected SWEUtils sweUtils = new SWEUtils("2.0");
    protected SWEFilter streamFilter;
    protected DataArrayImpl coverageArray;

    public void parse(InputStream inputStream, DataHandler handler) throws IOException {
        try {
            this.dataHandler = handler;
            this.streamFilter = new SWEFilter(inputStream);
            this.streamFilter.setDataElementName("values");
            DOMHelper dom = new DOMHelper((InputStream)this.streamFilter, false);
            OGCExceptionReader.checkException((DOMHelper)dom);
            Element rootElement = dom.getRootElement();
            NodeList elts = rootElement.getOwnerDocument().getElementsByTagNameNS("http://www.opengis.net/om/1.0", "Observation");
            Element obsElt = (Element)elts.item(0);
            if (obsElt == null) {
                throw new XMLReaderException("XML Response doesn't contain any Observation");
            }
            Element resultArrayElt = dom.getElement(obsElt, "result/*");
            Element countElt = dom.getElement(resultArrayElt, "elementCount/Count");
            String countValue = dom.getElementValue(countElt, "value");
            int arraySize = Integer.parseInt(countValue);
            this.coverageArray = new DataArrayImpl(arraySize);
            Element eltTypeElt = dom.getElement(resultArrayElt, "elementType/*");
            Element encElt = dom.getElement(resultArrayElt, "encoding/*");
            this.dataComponents = this.sweUtils.readComponent(dom, eltTypeElt);
            this.dataEncoding = this.sweUtils.readEncoding(dom, encElt);
            this.dataParser = this.createDataParser();
            this.coverageArray.addComponent(this.dataComponents.getName(), this.dataComponents);
            this.dataParser.setParentArray((BlockComponent)this.coverageArray);
            Element valElt = dom.getElement(resultArrayElt, "values");
            this.valuesUri = valElt.getAttribute("xlink:href");
            this.dataParser.parse((InputStream)new BufferedInputStream(this.getDataStream()));
        }
        catch (IllegalStateException e) {
            throw new XMLReaderException("No reader found for SWECommon", (Exception)e);
        }
        catch (DOMHelperException e) {
            throw new XMLReaderException("Error while parsing Observation XML", (Exception)((Object)e));
        }
        catch (OGCException e) {
            throw new XMLReaderException(e.getMessage());
        }
    }

    public DataArray getCoverageArray() {
        return this.coverageArray;
    }

    public InputStream getDataStream() throws IOException {
        if (this.valuesUri != null && this.valuesUri.length() > 0) {
            try {
                this.streamFilter.startReadingData();
                this.streamFilter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return URIStreamHandler.openStream((String)this.valuesUri);
        }
        this.streamFilter.startReadingData();
        return this.streamFilter;
    }
}

