/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcst;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractResponseWriter;
import org.vast.ows.OWSException;
import org.vast.ows.wcst.WCSTransactionAck;
import org.vast.ows.wcst.WCSTransactionRequest;
import org.vast.ows.wcst.WCSTransactionWriterV11;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WCSTransactionAckWriterV11
extends AbstractResponseWriter<WCSTransactionAck> {
    protected WCSTransactionWriterV11 requestWriter = new WCSTransactionWriterV11();

    @Override
    public Element buildXMLResponse(DOMHelper dom, WCSTransactionAck response, String version) throws OWSException {
        WCSTransactionRequest request = response.getRequest();
        dom.addUserPrefix("_NIL_", OGCRegistry.getNamespaceURI((String)"WCS", (String)request.getVersion()));
        Element rootElt = dom.createElement("Acknowledgement");
        String timeStamp = this.timeFormat.formatIso(response.getTimeStamp().getJulianTime(), 0);
        dom.setElementValue(rootElt, "TimeStamp", timeStamp);
        Element originalRequestElt = dom.addElement((Node)rootElt, "OperationRequest");
        Element requestElt = this.requestWriter.buildXMLQuery(dom, request);
        originalRequestElt.appendChild(dom.getFirstChildElement(requestElt));
        return rootElt;
    }
}

