/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcst;

import java.util.Map;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.OWSCommonReaderV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.OWSReference;
import org.vast.ows.wcs.WCSException;
import org.vast.ows.wcst.CoverageTransaction;
import org.vast.ows.wcst.WCSTransactionRequest;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WCSTransactionReaderV11
extends AbstractRequestReader<WCSTransactionRequest> {
    protected OWSCommonReaderV11 owsReader = new OWSCommonReaderV11();

    @Override
    public WCSTransactionRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        throw new WCSException("KVP request not supported in WCS 1.1 Transaction");
    }

    @Override
    public WCSTransactionRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport();
        WCSTransactionRequest request = new WCSTransactionRequest();
        WCSTransactionReaderV11.readCommonXML(dom, requestElt, request);
        NodeList covElts = dom.getElements(requestElt, "InputCoverages/Coverage");
        for (int i = 0; i < covElts.getLength(); ++i) {
            OWSReference ref;
            Element refElt;
            int j;
            CoverageTransaction coverageRef = new CoverageTransaction();
            Element coverageElt = (Element)covElts.item(i);
            this.owsReader.readIdentification(dom, coverageElt, coverageRef);
            NodeList refElts = dom.getElements(coverageElt, "Reference");
            for (j = 0; j < refElts.getLength(); ++j) {
                refElt = (Element)refElts.item(j);
                ref = this.owsReader.readReference(dom, refElt);
                coverageRef.getReferenceList().add(ref);
            }
            refElts = dom.getElements(coverageElt, "ServiceReference");
            for (j = 0; j < refElts.getLength(); ++j) {
                refElt = (Element)refElts.item(j);
                ref = this.owsReader.readReference(dom, refElt);
                coverageRef.getReferenceList().add(ref);
            }
            request.getInputCoverages().add(coverageRef);
        }
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(WCSTransactionRequest request, OWSExceptionReport report) throws OWSException {
        if (request.getInputCoverages().isEmpty()) {
            report.add(new OWSException("MissingParameterValue", "InputCoverages"));
        }
        AbstractRequestReader.checkParameters(request, report, "WCS");
    }
}

