/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wcst;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.OWSCommonWriterV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSReferenceGroup;
import org.vast.ows.wcs.WCSException;
import org.vast.ows.wcst.WCSTransactionRequest;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WCSTransactionWriterV11
extends AbstractRequestWriter<WCSTransactionRequest> {
    protected OWSCommonWriterV11 owsWriter = new OWSCommonWriterV11();

    @Override
    public String buildURLQuery(WCSTransactionRequest request) throws OWSException {
        throw new WCSException("KVP request not supported in WCS 1.1 Transaction");
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, WCSTransactionRequest request) throws OWSException {
        dom.addUserPrefix("_NIL_", OGCRegistry.getNamespaceURI((String)"WCS", (String)request.getVersion()));
        Element rootElt = dom.createElement("Transaction");
        this.addCommonXML(dom, rootElt, request);
        Element inputElt = dom.addElement((Node)rootElt, "InputCoverages");
        for (int i = 0; i < request.getInputCoverages().size(); ++i) {
            Element coverageElt = dom.addElement((Node)inputElt, "+Coverage");
            OWSReferenceGroup coverageInfo = request.getInputCoverages().get(i);
            this.owsWriter.buildRefGroup(dom, coverageElt, coverageInfo);
        }
        return rootElt;
    }
}

