/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wfs;

import java.util.ArrayList;
import org.vast.ows.AbstractCapabilitiesReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.wfs.WFSLayerCapabilities;
import org.vast.util.Bbox;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WFSCapabilitiesReaderV10
extends AbstractCapabilitiesReader {
    @Override
    public OWSServiceCapabilities readXMLResponse(DOMHelper dom, Element capabilitiesElt) throws OWSException {
        OWSServiceCapabilities serviceCaps = new OWSServiceCapabilities();
        String version = dom.getAttributeValue(capabilitiesElt, "version");
        serviceCaps.setVersion(version);
        Element serviceElt = dom.getElement(capabilitiesElt, "Service");
        String serviceTitle = dom.getElementValue(serviceElt, "Title");
        serviceCaps.getIdentification().setTitle(serviceTitle);
        String serviceType = dom.getElementValue(serviceElt, "Name");
        serviceCaps.setService(serviceType);
        String desc = dom.getElementValue(serviceElt, "Abstract");
        serviceCaps.getIdentification().setDescription(desc);
        this.readOperationsMetadata(dom, capabilitiesElt, serviceCaps);
        this.readContents(dom, capabilitiesElt, serviceCaps);
        return serviceCaps;
    }

    @Override
    protected void readOperationsMetadata(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        String url = dom.getAttributeValue("Capability/Request/GetFeature/DCPType/HTTP/Get/@onlineResource");
        if (url != null) {
            serviceCaps.getGetServers().put("GetFeature", url);
        }
        if ((url = dom.getAttributeValue("Capability/Request/GetFeature/DCPType/HTTP/Post/@onlineResource")) != null) {
            serviceCaps.getPostServers().put("GetFeature", url);
        }
    }

    @Override
    protected void readContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) {
        ArrayList<String> formatList = this.getFormatList(dom, capsElt);
        NodeList featureList = dom.getElements("FeatureTypeList/FeatureType");
        for (int i = 0; i < featureList.getLength(); ++i) {
            Element featureElt = (Element)featureList.item(i);
            WFSLayerCapabilities featureCaps = this.readFeature(dom, featureElt, serviceCaps);
            featureCaps.setFormatList(formatList);
            serviceCaps.getLayers().add(featureCaps);
        }
    }

    protected ArrayList<String> getFormatList(DOMHelper dom, Element capsElt) {
        ArrayList<String> formatList = null;
        Element getMapElt = dom.getElement(capsElt, "Capability/Request/GetFeature");
        if (getMapElt == null) {
            getMapElt = dom.getElement(capsElt, "Capability/Request/GetFeatureType");
        }
        Element formatElement = dom.getElement(getMapElt, "ResultFormat");
        NodeList formatElts = dom.getAllChildElements(formatElement);
        int listSize = formatElts.getLength();
        formatList = new ArrayList<String>(listSize);
        for (int i = 0; i < listSize; ++i) {
            formatElement = (Element)formatElts.item(i);
            String formatName = formatElement.getLocalName();
            formatList.add(formatName);
        }
        return formatList;
    }

    protected WFSLayerCapabilities readFeature(DOMHelper dom, Element featureElt, OWSServiceCapabilities serviceCaps) {
        WFSLayerCapabilities layerCaps = new WFSLayerCapabilities();
        layerCaps.setParent(serviceCaps);
        String name = dom.getElementValue(featureElt, "name");
        layerCaps.setIdentifier(name);
        String title = dom.getElementValue(featureElt, "title");
        if (title != null) {
            layerCaps.setTitle(title);
        } else {
            layerCaps.setTitle(name);
        }
        this.getSRSList(dom, featureElt, layerCaps);
        this.getBBOXList(dom, featureElt, layerCaps);
        return layerCaps;
    }

    protected void getSRSList(DOMHelper dom, Element featureElement, WFSLayerCapabilities layerCaps) {
        ArrayList<String> srsList = new ArrayList<String>();
        NodeList srsElts = dom.getElements(featureElement, "SRS");
        int listSize = srsElts.getLength();
        for (int i = 0; i < listSize; ++i) {
            Element srsElement = (Element)srsElts.item(i);
            String srsNames = dom.getElementValue(srsElement, "");
            String[] srsArray = srsNames.split(" ");
            for (int j = 0; j < srsArray.length; ++j) {
                srsList.add(srsArray[j]);
            }
        }
        srsList.trimToSize();
        layerCaps.setSrsList(srsList);
    }

    protected void getBBOXList(DOMHelper dom, Element featureElement, WFSLayerCapabilities layerCaps) {
        NodeList bboxElts = dom.getElements(featureElement, "LatLonBoundingBox");
        if (bboxElts.getLength() == 0) {
            bboxElts = dom.getElements(featureElement, "LatLongBoundingBox");
        }
        int listSize = bboxElts.getLength();
        ArrayList<Bbox> bboxList = new ArrayList<Bbox>(listSize);
        for (int i = 0; i < listSize; ++i) {
            Element bboxElement = (Element)bboxElts.item(i);
            double minX = Double.parseDouble(dom.getAttributeValue(bboxElement, "minx"));
            double minY = Double.parseDouble(dom.getAttributeValue(bboxElement, "miny"));
            double maxX = Double.parseDouble(dom.getAttributeValue(bboxElement, "maxx"));
            double maxY = Double.parseDouble(dom.getAttributeValue(bboxElement, "maxy"));
            Bbox bbox = new Bbox();
            bbox.setMinX(minX);
            bbox.setMaxX(maxX);
            bbox.setMinY(minY);
            bbox.setMaxY(maxY);
            bboxList.add(bbox);
        }
        layerCaps.setBboxList(bboxList);
    }
}

