/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wms;

import java.awt.Color;
import java.util.Map;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.wms.GetMapRequest;
import org.vast.ows.wms.WMSException;
import org.vast.util.Bbox;
import org.vast.util.TimeExtent;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class GetMapReaderV10
extends AbstractRequestReader<GetMapRequest> {
    public GetMapReaderV10() {
        this.owsVersion = "1.0";
    }

    @Override
    public GetMapRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        GetMapRequest request = new GetMapRequest();
        OWSExceptionReport report = new OWSExceptionReport(this.owsVersion);
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            try {
                int i;
                if (argName.equalsIgnoreCase("service")) {
                    request.setService(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("version")) {
                    request.setVersion(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("request")) {
                    request.setOperation(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("layers")) {
                    String[] layerList = argValue.split(",");
                    request.getLayers().clear();
                    for (i = 0; i < layerList.length; ++i) {
                        request.getLayers().add(layerList[i]);
                    }
                    continue;
                }
                if (argName.equalsIgnoreCase("styles")) {
                    String[] styleList = argValue.split(",");
                    request.getStyles().clear();
                    for (i = 0; i < styleList.length; ++i) {
                        request.getStyles().add(styleList[i]);
                    }
                    continue;
                }
                if (argName.equalsIgnoreCase("srs")) {
                    request.setSrs(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("bbox")) {
                    Bbox bbox = this.parseBboxArg(argValue);
                    request.setBbox(bbox);
                    continue;
                }
                if (argName.equalsIgnoreCase("width")) {
                    request.setWidth(Integer.parseInt(argValue));
                    if (request.getWidth() > 0) continue;
                    throw new IllegalArgumentException();
                }
                if (argName.equalsIgnoreCase("height")) {
                    request.setHeight(Integer.parseInt(argValue));
                    if (request.getHeight() > 0) continue;
                    throw new IllegalArgumentException();
                }
                if (argName.equalsIgnoreCase("format")) {
                    request.setFormat(argValue);
                    continue;
                }
                if (argName.equalsIgnoreCase("transparent")) {
                    request.setTransparent(Boolean.parseBoolean(argValue));
                    continue;
                }
                if (argName.equalsIgnoreCase("bgcolor")) {
                    request.setBackgroundColor(this.parseBgColor(argValue));
                    continue;
                }
                if (argName.equalsIgnoreCase("time")) {
                    TimeExtent time = this.parseTimeArg(argValue);
                    request.setTime(time);
                    continue;
                }
                if (argValue == null) {
                    argValue = "";
                }
                this.addKVPExtension(argName, argValue, request);
            }
            catch (Exception e) {
                report.add(new WMSException("InvalidParameterValue", argName.toUpperCase(), argValue, null));
            }
        }
        report.process();
        this.checkParameters(request, report);
        return request;
    }

    @Override
    public GetMapRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        throw new WMSException("XML request not supported in WMS 1.0 GetMap");
    }

    protected Color parseBgColor(String argValue) {
        if (argValue == null || !argValue.matches("0(x|X)[0-9a-fA-F]{6}")) {
            throw new IllegalArgumentException();
        }
        argValue.replaceFirst("0x|0X", "");
        return Color.decode(argValue);
    }

    protected void checkParameters(GetMapRequest request, OWSExceptionReport report) throws OWSException {
        AbstractRequestReader.checkParameters(request, report, "WMS");
        if (request.getLayers() == null || request.getLayers().isEmpty()) {
            report.add(new WMSException("MissingParameterValue", "LAYERS"));
        }
        if (request.getBbox() == null || request.getBbox().isNull()) {
            report.add(new WMSException("MissingParameterValue", "BBOX"));
        }
        if (request.getFormat() == null || request.getFormat().length() == 0) {
            report.add(new WMSException("MissingParameterValue", "FORMAT"));
        }
        if (request.getSrs() == null || request.getSrs().length() == 0) {
            report.add(new WMSException("MissingParameterValue", "SRS"));
        }
        if (request.getStyles() == null) {
            report.add(new WMSException("MissingParameterValue", "STYLES"));
        }
        if (request.getWidth() <= 0) {
            report.add(new WMSException("MissingParameterValue", "WIDTH"));
        }
        if (request.getHeight() <= 0) {
            report.add(new WMSException("MissingParameterValue", "HEIGHT"));
        }
        report.process();
    }
}

