/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wms;

import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.wms.GetMapReaderV10;
import org.vast.ows.wms.GetMapRequest;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetMapReaderV11
extends GetMapReaderV10 {
    public GetMapReaderV11() {
        this.owsVersion = "1.1.0";
    }

    @Override
    public GetMapRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        GetMapRequest request = new GetMapRequest();
        GetMapReaderV11.readCommonXML(dom, requestElt, request);
        NodeList layerElts = dom.getElements(requestElt, "StyledLayerDescriptor/NamedLayer");
        for (int i = 0; i < layerElts.getLength(); ++i) {
            Element elt = (Element)layerElts.item(i);
            request.getLayers().add(dom.getElementValue(elt, "Name"));
            String styleName = dom.getElementValue(elt, "NamedStyle/Name");
            if (styleName == null) {
                styleName = "";
            }
            request.getStyles().add(styleName);
        }
        String bboxText = dom.getElementValue(requestElt, "BoundingBox/coordinates");
        request.setBbox(this.parseBboxArg(bboxText));
        request.setSrs(dom.getAttributeValue(requestElt, "BoundingBox/srsName"));
        request.setFormat(dom.getElementValue(requestElt, "Output/Format"));
        String transparency = dom.getElementValue(requestElt, "Output/Transparent");
        request.setTransparent(transparency.equalsIgnoreCase("true"));
        request.setWidth(Integer.parseInt(dom.getElementValue(requestElt, "Output/Size/Width")));
        request.setHeight(Integer.parseInt(dom.getElementValue(requestElt, "Output/Size/Height")));
        request.setExceptionType(dom.getElementValue(requestElt, "Exceptions"));
        this.checkParameters(request, new OWSExceptionReport("1.1.0"));
        return request;
    }
}

