/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wms;

import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.OWSException;
import org.vast.ows.wms.GetMapRequest;
import org.vast.ows.wms.WMSException;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class GetMapWriterV10
extends AbstractRequestWriter<GetMapRequest> {
    @Override
    public String buildURLQuery(GetMapRequest request) throws OWSException {
        StringBuilder urlBuff = new StringBuilder(request.getGetServer());
        urlBuff.append("wmtver=" + request.getVersion());
        urlBuff.append("&request=map");
        urlBuff.append("&layers=" + this.createLayerList(request));
        urlBuff.append("&styles=" + this.createStyleList(request));
        urlBuff.append("&srs=" + request.getSrs());
        urlBuff.append("&bbox=");
        this.writeBboxArgument(urlBuff, request.getBbox());
        urlBuff.append("&width=" + request.getWidth());
        urlBuff.append("&height=" + request.getHeight());
        urlBuff.append("&format=" + request.getFormat());
        urlBuff.append("&transparent=" + (request.isTransparent() ? "TRUE" : "FALSE"));
        urlBuff.append("&exceptions=" + request.getExceptionType());
        String url = urlBuff.toString();
        url.replaceAll(" ", "%20");
        return url;
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, GetMapRequest request) throws OWSException {
        throw new WMSException("XML request not supported in WMS 1.0");
    }

    protected String createLayerList(GetMapRequest request) {
        StringBuffer buff = new StringBuffer();
        int layerCount = request.getLayers().size();
        for (int i = 0; i < layerCount; ++i) {
            buff.append(request.getLayers().get(i));
            if (i == layerCount - 1) continue;
            buff.append(',');
        }
        return buff.toString();
    }

    protected String createStyleList(GetMapRequest request) {
        StringBuffer buff = new StringBuffer();
        int styleCount = request.getStyles().size();
        for (int i = 0; i < styleCount; ++i) {
            buff.append(request.getStyles().get(i));
            if (i == styleCount - 1) continue;
            buff.append(',');
        }
        return buff.toString();
    }
}

