/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wms;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.wms.GetMapRequest;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetMapWriterV11
extends AbstractRequestWriter<GetMapRequest> {
    @Override
    public String buildURLQuery(GetMapRequest request) throws OWSException {
        StringBuilder urlBuff = new StringBuilder(request.getGetServer());
        this.addCommonArgs(urlBuff, (OWSRequest)request);
        urlBuff.append("&layers=" + this.createLayerList(request));
        urlBuff.append("&styles=" + this.createStyleList(request));
        urlBuff.append("&srs=" + request.getSrs());
        urlBuff.append("&bbox=");
        this.writeBboxArgument(urlBuff, request.getBbox());
        urlBuff.append("&width=" + request.getWidth());
        urlBuff.append("&height=" + request.getHeight());
        urlBuff.append("&format=" + request.getFormat());
        urlBuff.append("&transparent=" + (request.isTransparent() ? "TRUE" : "FALSE"));
        urlBuff.append("&exceptions=" + request.getExceptionType());
        String url = urlBuff.toString();
        url.replaceAll(" ", "%20");
        return url;
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, GetMapRequest request) throws OWSException {
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS"));
        dom.addUserPrefix("ogc", OGCRegistry.getNamespaceURI((String)"OGC"));
        dom.addUserPrefix("gml", OGCRegistry.getNamespaceURI((String)"GML"));
        dom.addUserPrefix("sld", OGCRegistry.getNamespaceURI((String)"SLD"));
        Element rootElt = dom.createElement("ows:GetMap");
        dom.setAttributeValue(rootElt, "version", request.getVersion());
        dom.setAttributeValue(rootElt, "service", request.getService());
        for (int i = 0; i < request.getLayers().size(); ++i) {
            Element layerdElt = dom.addElement((Node)rootElt, "sld:StyledLayerDescriptor/+sld:NamedLayer");
            dom.setElementValue(layerdElt, "sld:Name", request.getLayers().get(i));
            if (request.getStyles().isEmpty()) continue;
            dom.setElementValue(layerdElt, "sld:NamedStyle/sld:Name", request.getStyles().get(i));
        }
        dom.setElementValue(rootElt, "ows:BoundingBox/gml:coordinates", this.getGmlBboxCoordsList(request.getBbox()));
        dom.setAttributeValue(rootElt, "ows:BoundingBox/@srsName", request.getSrs());
        dom.setElementValue(rootElt, "ows:Output/ows:Format", request.getFormat());
        dom.setElementValue(rootElt, "ows:Output/ows:Transparent", request.isTransparent() ? "TRUE" : "FALSE");
        dom.setElementValue(rootElt, "ows:Output/ows:Size/ows:Width", Integer.toString(request.getWidth()));
        dom.setElementValue(rootElt, "ows:Output/ows:Size/ows:Height", Integer.toString(request.getHeight()));
        dom.setElementValue(rootElt, "ows:Exceptions", request.getExceptionType());
        return rootElt;
    }

    protected String createLayerList(GetMapRequest request) {
        StringBuffer buff = new StringBuffer();
        int layerCount = request.getLayers().size();
        for (int i = 0; i < layerCount; ++i) {
            buff.append(request.getLayers().get(i));
            if (i == layerCount - 1) continue;
            buff.append(',');
        }
        return buff.toString();
    }

    protected String createStyleList(GetMapRequest request) {
        StringBuffer buff = new StringBuffer();
        int styleCount = request.getStyles().size();
        for (int i = 0; i < styleCount; ++i) {
            buff.append(request.getStyles().get(i));
            if (i == styleCount - 1) continue;
            buff.append(',');
        }
        return buff.toString();
    }
}

