/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wms;

import java.util.ArrayList;
import org.vast.ows.AbstractCapabilitiesReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.wms.WMSLayerCapabilities;
import org.vast.util.Bbox;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WMSCapabilitiesReaderV10
extends AbstractCapabilitiesReader {
    ArrayList<String> formatList;

    @Override
    public OWSServiceCapabilities readXMLResponse(DOMHelper dom, Element capabilitiesElt) throws OWSException {
        OWSServiceCapabilities serviceCaps = new OWSServiceCapabilities();
        String version = dom.getAttributeValue(capabilitiesElt, "version");
        serviceCaps.setVersion(version);
        Element serviceElt = dom.getElement(capabilitiesElt, "Service");
        String serviceTitle = dom.getElementValue(serviceElt, "Title");
        serviceCaps.getIdentification().setTitle(serviceTitle);
        String serviceType = dom.getElementValue(serviceElt, "Name");
        serviceCaps.setService(serviceType);
        String desc = dom.getElementValue(serviceElt, "Abstract");
        serviceCaps.getIdentification().setDescription(desc);
        this.readOperationsMetadata(dom, capabilitiesElt, serviceCaps);
        this.readContents(dom, capabilitiesElt, serviceCaps);
        return serviceCaps;
    }

    @Override
    protected void readOperationsMetadata(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        String url = dom.getAttributeValue(capsElt, "Capability/Request/Map/DCPType/HTTP/Get/onlineResource");
        if (url != null) {
            serviceCaps.getGetServers().put("GetMap", url);
        }
        if ((url = dom.getAttributeValue(capsElt, "Capability/Request/Map/DCPType/HTTP/Post/onlineResource")) != null) {
            serviceCaps.getPostServers().put("GetMap", url);
        }
    }

    @Override
    protected void readContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) {
        this.readFormatList(dom, capsElt);
        Element rootLayer = dom.getElement(capsElt, "Capability/Layer");
        WMSLayerCapabilities layerCaps = this.readLayer(dom, rootLayer, null, serviceCaps);
        if (!serviceCaps.getLayers().contains(layerCaps)) {
            serviceCaps.getLayers().add(0, layerCaps);
        }
    }

    protected void readFormatList(DOMHelper dom, Element capsElt) {
        Element getMapElt = dom.getElement(capsElt, "Capability/Request/Map");
        if (getMapElt == null) {
            getMapElt = dom.getElement(capsElt, "Capability/Request/GetMap");
        }
        Element formatElement = dom.getElement(getMapElt, "Format");
        NodeList formatElts = dom.getAllChildElements(formatElement);
        int listSize = formatElts.getLength();
        this.formatList = new ArrayList(listSize);
        for (int i = 0; i < listSize; ++i) {
            formatElement = (Element)formatElts.item(i);
            String formatName = formatElement.getLocalName();
            this.formatList.add(formatName);
        }
    }

    protected WMSLayerCapabilities readLayer(DOMHelper dom, Element layerElt, WMSLayerCapabilities parentCaps, OWSServiceCapabilities serviceCaps) {
        NodeList childLayers;
        int listSize;
        WMSLayerCapabilities layerCaps = new WMSLayerCapabilities();
        layerCaps.setParent(serviceCaps);
        String id = dom.getElementValue(layerElt, "Name");
        layerCaps.setIdentifier(id);
        String name = dom.getElementValue(layerElt, "Title");
        layerCaps.setTitle(name);
        String desc = dom.getElementValue(layerElt, "Abstract");
        layerCaps.setDescription(desc);
        this.getSRSList(dom, layerElt, layerCaps);
        this.getStyleList(dom, layerElt, layerCaps);
        this.getBBOXList(dom, layerElt, layerCaps);
        layerCaps.setFormatList(this.formatList);
        this.mergeWithParent(layerCaps, parentCaps);
        if (layerCaps.getIdentifier() != null) {
            serviceCaps.getLayers().add(layerCaps);
        }
        if ((listSize = (childLayers = dom.getElements(layerElt, "Layer")).getLength()) > 0) {
            layerCaps.setChildLayers(new ArrayList<WMSLayerCapabilities>(listSize));
        }
        for (int i = 0; i < listSize; ++i) {
            Element childLayer = (Element)childLayers.item(i);
            WMSLayerCapabilities childCaps = this.readLayer(dom, childLayer, layerCaps, serviceCaps);
            layerCaps.getChildLayers().add(childCaps);
        }
        return layerCaps;
    }

    protected void getSRSList(DOMHelper dom, Element layerElement, WMSLayerCapabilities layerCaps) {
        ArrayList<String> srsList = null;
        String srsNames = dom.getElementValue(layerElement, "SRS");
        if (srsNames == null) {
            return;
        }
        String[] srsArray = srsNames.split(" ");
        int listSize = srsArray.length;
        srsList = new ArrayList<String>(listSize);
        for (int i = 0; i < listSize; ++i) {
            srsList.add(srsArray[i]);
        }
        layerCaps.setSrsList(srsList);
    }

    protected void getStyleList(DOMHelper dom, Element layerElement, WMSLayerCapabilities layerCaps) {
        NodeList styleElts = dom.getElements(layerElement, "Style");
        int listSize = styleElts.getLength();
        ArrayList<String> styleList = new ArrayList<String>(listSize);
        for (int i = 0; i < listSize; ++i) {
            Element styleElement = (Element)styleElts.item(i);
            String styleName = dom.getElementValue(styleElement, "Name");
            styleList.add(styleName);
        }
        layerCaps.setStyleList(styleList);
    }

    protected void getBBOXList(DOMHelper dom, Element layerElement, WMSLayerCapabilities layerCaps) {
        NodeList bboxElts = dom.getElements(layerElement, "LatLonBoundingBox");
        int listSize = bboxElts.getLength();
        ArrayList<Bbox> bboxList = new ArrayList<Bbox>(listSize);
        for (int i = 0; i < listSize; ++i) {
            Element bboxElement = (Element)bboxElts.item(i);
            double minX = Double.parseDouble(dom.getAttributeValue(bboxElement, "minx"));
            double minY = Double.parseDouble(dom.getAttributeValue(bboxElement, "miny"));
            double maxX = Double.parseDouble(dom.getAttributeValue(bboxElement, "maxx"));
            double maxY = Double.parseDouble(dom.getAttributeValue(bboxElement, "maxy"));
            Bbox bbox = new Bbox();
            bbox.setMinX(minX);
            bbox.setMaxX(maxX);
            bbox.setMinY(minY);
            bbox.setMaxY(maxY);
            bboxList.add(bbox);
        }
        layerCaps.setBboxList(bboxList);
    }

    protected void getExtentList(DOMHelper dom, Element layerElement, WMSLayerCapabilities layerCaps) {
    }

    protected void mergeWithParent(WMSLayerCapabilities layerCaps, WMSLayerCapabilities parentCaps) {
        if (parentCaps == null) {
            return;
        }
        layerCaps.getStyleList().addAll(parentCaps.getStyleList());
        layerCaps.getSrsList().addAll(parentCaps.getSrsList());
        if (layerCaps.getBboxList().isEmpty()) {
            layerCaps.getBboxList().addAll(parentCaps.getBboxList());
        }
        if (layerCaps.getMaxHeight() == -1) {
            layerCaps.setMaxHeight(parentCaps.getMaxHeight());
        }
        if (layerCaps.getMaxWidth() == -1) {
            layerCaps.setMaxWidth(parentCaps.getMaxWidth());
        }
    }
}

