/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wms;

import java.util.ArrayList;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.wms.WMSCapabilitiesReaderV10;
import org.vast.ows.wms.WMSLayerCapabilities;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WMSCapabilitiesReaderV11
extends WMSCapabilitiesReaderV10 {
    @Override
    protected void readOperationsMetadata(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) throws OWSException {
        String url = dom.getAttributeValue(capsElt, "Capability/Request/GetMap/DCPType/HTTP/Get/OnlineResource/@href");
        if (url != null) {
            serviceCaps.getGetServers().put("GetMap", url);
        }
        if ((url = dom.getAttributeValue(capsElt, "Capability/Request/GetMap/DCPType/HTTP/Post/OnlineResource/@href")) != null) {
            serviceCaps.getPostServers().put("GetMap", url);
        }
    }

    @Override
    protected void readFormatList(DOMHelper dom, Element capsElt) {
        Element getMapElt = dom.getElement(capsElt, "Capability/Request/GetMap");
        NodeList formatElts = dom.getElements(getMapElt, "Format");
        int listSize = formatElts.getLength();
        this.formatList = new ArrayList(listSize);
        for (int i = 0; i < listSize; ++i) {
            Element formatElement = (Element)formatElts.item(i);
            String formatName = dom.getElementValue(formatElement, "");
            this.formatList.add(formatName);
        }
    }

    @Override
    protected void getSRSList(DOMHelper dom, Element layerElement, WMSLayerCapabilities layerCaps) {
        ArrayList<String> srsList = null;
        NodeList srsElts = dom.getElements(layerElement, "SRS");
        int listSize = srsElts.getLength();
        srsList = new ArrayList<String>(listSize);
        for (int i = 0; i < listSize; ++i) {
            Element srsElement = (Element)srsElts.item(i);
            String srsName = dom.getElementValue(srsElement, "");
            srsList.add(srsName);
        }
        layerCaps.setSrsList(srsList);
    }
}

