/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wns;

import java.util.Map;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.wns.MultiUser;
import org.vast.ows.wns.RegisterRequest;
import org.vast.ows.wns.SingleUser;
import org.vast.ows.wns.WNSException;
import org.vast.ows.wns.WNSUser;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RegisterReaderV10
extends AbstractRequestReader<RegisterRequest> {
    @Override
    public RegisterRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        throw new WNSException("KVP request not supported in WNS Register version 1.0");
    }

    @Override
    public RegisterRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport();
        RegisterRequest request = new RegisterRequest();
        RegisterReaderV10.readCommonXML(dom, requestElt, request);
        Element userElt = dom.getFirstChildElement(requestElt);
        WNSUser user = this.readUser(dom, userElt);
        request.setUser(user);
        this.checkParameters(request, report);
        return request;
    }

    public WNSUser readUser(DOMHelper dom, Element userElt) throws OWSException {
        if (userElt.getLocalName().equals("SingleUser")) {
            SingleUser user = new SingleUser();
            String userName = dom.getElementValue(userElt, "Name");
            user.setName(userName);
            NodeList protocolElts = dom.getElements(userElt, "CommunicationProtocol/*");
            for (int i = 0; i < protocolElts.getLength(); ++i) {
                Element protocolElt = (Element)protocolElts.item(i);
                String protocol = protocolElt.getLocalName();
                String address = dom.getElementValue(protocolElt);
                user.addProtocol(protocol, address);
            }
            return user;
        }
        if (userElt.getLocalName().equals("MultiUser")) {
            MultiUser user = new MultiUser();
            NodeList userIdElts = dom.getElements(userElt, "UserID");
            for (int i = 0; i < userIdElts.getLength(); ++i) {
                Element userIdElt = (Element)userIdElts.item(i);
                String userId = dom.getElementValue(userIdElt);
                user.getUserIds().add(userId);
            }
            return user;
        }
        throw new WNSException("Invalid XML Request");
    }

    protected void checkParameters(RegisterRequest request, OWSExceptionReport report) throws OWSException {
        AbstractRequestReader.checkParameters(request, report, "WNS");
        WNSUser user = request.getUser();
        if (user == null) {
            report.add(new WNSException("MissingParameterValue", "User"));
        }
        if (user instanceof SingleUser) {
            SingleUser singleUser = (SingleUser)user;
            String name = singleUser.getName();
            if (name == null) {
                report.add(new WNSException("MissingParameterValue", "Name"));
            }
            if (singleUser.getProtocolTable().isEmpty()) {
                report.add(new WNSException("MissingParameterValue", "CommunicationProtocol"));
            }
        } else if (user instanceof MultiUser) {
            MultiUser multiUser = (MultiUser)user;
            if (multiUser.getUserIds().isEmpty()) {
                report.add(new WNSException("MissingParameterValue", "UserID"));
            } else if (multiUser.getUserIds().size() < 2) {
                report.add(new WNSException("InvalidParameterValue", "UserID"));
            }
        }
        report.process();
    }
}

