/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wns;

import java.util.Enumeration;
import java.util.List;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.OWSException;
import org.vast.ows.wns.MultiUser;
import org.vast.ows.wns.RegisterRequest;
import org.vast.ows.wns.SingleUser;
import org.vast.ows.wns.WNSException;
import org.vast.ows.wns.WNSUser;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegisterWriterV10
extends AbstractRequestWriter<RegisterRequest> {
    @Override
    public String buildURLQuery(RegisterRequest request) throws OWSException {
        throw new WNSException("KVP request not supported in WNS version 1.0");
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, RegisterRequest request) throws OWSException {
        dom.addUserPrefix("_NIL_", OGCRegistry.getNamespaceURI((String)"WNS"));
        Element rootElt = dom.createElement("Register");
        this.addCommonXML(dom, rootElt, request);
        Element userElt = this.writeUser(dom, request.getUser());
        rootElt.appendChild(userElt);
        return rootElt;
    }

    public Element writeUser(DOMHelper dom, WNSUser user) {
        if (user instanceof SingleUser) {
            SingleUser singleUser = (SingleUser)user;
            Element singleUserElt = dom.createElement("SingleUser");
            dom.setElementValue(singleUserElt, "Name", singleUser.getName());
            Element commElt = dom.addElement((Node)singleUserElt, "CommunicationProtocol");
            Enumeration<String> protocols = singleUser.getProtocolTable().keys();
            while (protocols.hasMoreElements()) {
                String protocol = protocols.nextElement();
                List<String> addressList = singleUser.getProtocolTable().get(protocol);
                for (int i = 0; i < addressList.size(); ++i) {
                    dom.setElementValue(commElt, protocol, addressList.get(i));
                }
            }
            return singleUserElt;
        }
        if (user instanceof MultiUser) {
            MultiUser multiUser = (MultiUser)user;
            Element multiUserElt = dom.createElement("MultiUser");
            List<String> userIds = multiUser.getUserIds();
            for (int i = 0; i < userIds.size(); ++i) {
                dom.setElementValue(multiUserElt, "UserID", userIds.get(i));
            }
            return multiUserElt;
        }
        return null;
    }
}

