/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wns;

import org.vast.ows.OWSCapabilitiesReaderV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.wns.WNSCapabilities;
import org.vast.ows.wns.WNSException;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WNSCapabilitiesReaderV10
extends OWSCapabilitiesReaderV11 {
    @Override
    public OWSServiceCapabilities readXMLResponse(DOMHelper dom, Element capabilitiesElt) throws OWSException {
        OWSServiceCapabilities caps = super.readXMLResponse(dom, capabilitiesElt);
        caps.setService("WNS");
        return caps;
    }

    @Override
    protected void readContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) throws WNSException {
        WNSCapabilities wnsCaps = new WNSCapabilities();
        NodeList protocolElts = dom.getElements(capsElt, "Contents/SupportedCommunicationProtocols/*");
        int listSize = protocolElts.getLength();
        for (int i = 0; i < listSize; ++i) {
            Element protocolElt = (Element)protocolElts.item(i);
            String flag = dom.getElementValue(protocolElt);
            if (!flag.equalsIgnoreCase("true")) continue;
            wnsCaps.getSupportedProtocols().add(protocolElt.getLocalName());
        }
        serviceCaps.getLayers().add(wnsCaps);
    }
}

