/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wns;

import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSCapabilitiesWriterV11;
import org.vast.ows.OWSException;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.wns.WNSCapabilities;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WNSCapabilitiesWriterV10
extends OWSCapabilitiesWriterV11 {
    @Override
    public Element buildXMLResponse(DOMHelper dom, OWSServiceCapabilities caps, String version) throws OWSException {
        dom.addUserPrefix("_NIL_", OGCRegistry.getNamespaceURI((String)"WNS"));
        dom.addUserPrefix("ows", OGCRegistry.getNamespaceURI((String)"OWS"));
        dom.addUserPrefix("xlink", OGCRegistry.getNamespaceURI((String)"XLINK"));
        Element capsElt = dom.createElement("Capabilities");
        this.writeRootAttributes(dom, capsElt, caps, version);
        this.writeServiceIdentification(dom, capsElt, caps);
        this.writeServiceProvider(dom, capsElt, caps.getServiceProvider());
        this.writeOperationsMetadata(dom, capsElt, caps);
        this.writeContents(dom, capsElt, caps, version);
        return capsElt;
    }

    @Override
    protected void writeContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities caps, String version) throws OWSException {
        Element contentsElt = dom.addElement((Node)capsElt, "Contents");
        Element suppProtocolElt = dom.addElement((Node)contentsElt, "SupportedCommunicationProtocols");
        WNSCapabilities wnsCaps = (WNSCapabilities)caps.getLayers().get(0);
        String[] allProtocols = new String[]{"XMPP", "SMS", "Phone", "Fax", "Email"};
        for (int i = 0; i < allProtocols.length; ++i) {
            boolean supported = false;
            if (wnsCaps.getSupportedProtocols().contains(allProtocols[i])) {
                supported = true;
            }
            dom.setElementValue(suppProtocolElt, allProtocols[i], Boolean.toString(supported));
        }
        dom.setElementValue(contentsElt, "MaxTTLOfMessages", "PT1D");
    }
}

