/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wps;

import java.util.Map;
import org.vast.ows.AbstractRequestReader;
import org.vast.ows.OWSException;
import org.vast.ows.OWSExceptionReport;
import org.vast.ows.wps.DescribeProcessRequest;
import org.vast.ows.wps.WPSException;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class DescribeProcessRequestReader
extends AbstractRequestReader<DescribeProcessRequest> {
    @Override
    public DescribeProcessRequest readURLParameters(Map<String, String> queryParameters) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        DescribeProcessRequest request = new DescribeProcessRequest();
        for (Map.Entry<String, String> item : queryParameters.entrySet()) {
            String argName = item.getKey();
            String argValue = item.getValue();
            if (argName.equalsIgnoreCase("service")) {
                request.setService(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("version")) {
                request.setVersion(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("request")) {
                request.setOperation(argValue);
                continue;
            }
            if (argName.equalsIgnoreCase("requestFormat")) {
                request.setRequestFormat(argValue);
                continue;
            }
            throw new WPSException("Invalid KVP Request: Unknown Argument " + argName);
        }
        this.checkParameters(request, report);
        return request;
    }

    @Override
    public DescribeProcessRequest readXMLQuery(DOMHelper dom, Element requestElt) throws OWSException {
        OWSExceptionReport report = new OWSExceptionReport("1.1.0");
        DescribeProcessRequest request = new DescribeProcessRequest();
        DescribeProcessRequestReader.readCommonXML(dom, requestElt, request);
        String requestFormat = dom.getElementValue(requestElt, "requestFormat");
        request.setRequestFormat(requestFormat);
        this.checkParameters(request, report);
        return request;
    }

    protected void checkParameters(DescribeProcessRequest request, OWSExceptionReport report) throws OWSException {
        AbstractRequestReader.checkParameters(request, report, "WPS");
        if (request.getRequestFormat() == null) {
            report.add(new OWSException("MissingParameterValue", "REQUEST_FORMAT"));
        }
        report.process();
    }
}

