/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wps;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.opengis.swe.v20.BinaryEncoding;
import net.opengis.swe.v20.DataEncoding;
import net.opengis.swe.v20.TextEncoding;
import net.opengis.swe.v20.XMLEncoding;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.OWSException;
import org.vast.ows.wps.ExecuteProcessRequest;
import org.vast.swe.AbstractDataWriter;
import org.vast.swe.SWEHelper;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;

public class ExecuteProcessRequestWriter
extends AbstractRequestWriter<ExecuteProcessRequest> {
    public static final String invalidEndpoint = "No Endpoint URL specified in request object";
    public static final String ioError = "IO Error while sending request:";

    public static InputStream writeData(ExecuteProcessRequest request) throws OWSException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AbstractDataWriter writer = (AbstractDataWriter)SWEHelper.createDataWriter((DataEncoding)request.getInputDataEncoding());
        writer.setDataEncoding(request.getInputDataEncoding());
        writer.setDataComponents(request.getInputDataComponent());
        writer.write((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return in;
    }

    @Override
    public Element buildXMLQuery(DOMHelper dom, ExecuteProcessRequest request) throws OWSException {
        dom.addUserPrefix("wps", OGCRegistry.getNamespaceURI((String)"WPS", (String)request.getVersion()));
        dom.addUserPrefix("ogc", OGCRegistry.getNamespaceURI((String)"OGC"));
        Element rootElt = dom.createElement("wps:executeProcess");
        this.addCommonXML(dom, rootElt, request);
        dom.setElementValue(rootElt, "wps:requestFormat", request.getOffering());
        dom.setElementValue(rootElt, "wps:requestFormat", ExecuteProcessRequestWriter.getContentType(request));
        return rootElt;
    }

    public Element buildXMLQuery(ExecuteProcessRequest request) throws OWSException {
        DOMHelper dom = new DOMHelper();
        return this.buildXMLQuery(dom, request);
    }

    @Override
    public String buildURLQuery(ExecuteProcessRequest request) throws OWSException {
        return null;
    }

    public static String getContentType(ExecuteProcessRequest request) throws OWSException {
        DataEncoding encoding = request.getInputDataEncoding();
        String requestFormat = null;
        if (encoding instanceof TextEncoding) {
            requestFormat = "text/plain";
        } else if (encoding instanceof XMLEncoding) {
            requestFormat = "text/xml";
        } else if (encoding instanceof BinaryEncoding) {
            requestFormat = "application/binary";
        } else {
            try {
                throw new IOException("IO Error while sending request:\nthis content-type is not handled. The content type can only be ascii (text/plain), xml (text/xml) or pure binary (application/binary)");
            }
            catch (IOException e) {
                throw new OWSException(e);
            }
        }
        return requestFormat;
    }
}

