/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wps;

import java.util.ArrayList;
import org.vast.ows.OWSCapabilitiesReaderV11;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.wps.WPSException;
import org.vast.ows.wps.WPSLayerCapabilities;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WPSCapabilitiesReader
extends OWSCapabilitiesReaderV11 {
    @Override
    protected void readContents(DOMHelper dom, Element capsElt, OWSServiceCapabilities serviceCaps) throws WPSException {
        NodeList offeringList = dom.getElements(capsElt, "Contents/ProcessOfferingList/ProcessOffering");
        for (int i = 0; i < offeringList.getLength(); ++i) {
            Element offeringElt = (Element)offeringList.item(i);
            String offeringName = dom.getElementValue(offeringElt, "name");
            Element methodElt = (Element)((Object)offeringElt.getElementsByTagName("method"));
            String methodURI = dom.getAttributeValue(methodElt, "xlink:href");
            if (offeringName == null) {
                offeringName = "Offering " + i + 1;
            }
            String id = dom.getAttributeValue(offeringElt, "id");
            WPSLayerCapabilities layerCaps = new WPSLayerCapabilities();
            layerCaps.setTitle(offeringName);
            layerCaps.setIdentifier(id);
            layerCaps.setMethod(methodURI);
            this.getResponseFormatList(dom, offeringElt, layerCaps);
            this.getRequestFormatList(dom, offeringElt, layerCaps);
            layerCaps.setParent(serviceCaps);
            serviceCaps.getLayers().add(layerCaps);
        }
    }

    protected void getResponseFormatList(DOMHelper dom, Element parentElement, WPSLayerCapabilities layerCaps) throws WPSException {
        NodeList responseFormatElts = dom.getElements(parentElement, "responseFormat");
        int listSize = responseFormatElts.getLength();
        ArrayList<String> responseFormatList = new ArrayList<String>(listSize);
        layerCaps.setResponseFormatList(responseFormatList);
        for (int i = 0; i < listSize; ++i) {
            Element responseFormatElt = (Element)responseFormatElts.item(i);
            String responseFormat = dom.getElementValue(responseFormatElt, "");
            responseFormatList.add(responseFormat);
        }
    }

    protected void getRequestFormatList(DOMHelper dom, Element parentElement, WPSLayerCapabilities layerCaps) throws WPSException {
        NodeList requestFormatElts = dom.getElements(parentElement, "requestFormat");
        int listSize = requestFormatElts.getLength();
        ArrayList<String> requestFormatList = new ArrayList<String>(listSize);
        layerCaps.setRequestFormatList(requestFormatList);
        for (int i = 0; i < listSize; ++i) {
            Element requestFormatElt = (Element)requestFormatElts.item(i);
            String requestFormat = dom.getElementValue(requestFormatElt, "");
            requestFormatList.add(requestFormat);
        }
    }
}

