/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wps;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.vast.cdm.common.CDMException;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.OWSException;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSRequestWriter;
import org.vast.ows.OWSResponse;
import org.vast.ows.OWSResponseReader;
import org.vast.ows.OWSUtils;
import org.vast.ows.util.PostRequestFilter;
import org.vast.ows.wps.ExecuteProcessRequest;
import org.vast.ows.wps.ExecuteProcessRequestWriter;
import org.vast.ows.wps.ExecuteProcessResponse;
import org.vast.xml.DOMHelper;
import org.vast.xml.DOMHelperException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WPSUtils
extends OWSUtils {
    public static final String ioError = "IO Error while sending request:";
    protected MessageFactory soapMessageFactory = MessageFactory.newInstance();
    protected SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
    private OWSUtils owsUtils;

    public OWSResponse getWPSResponse(OWSRequest request) throws SOAPException {
        Object response;
        URL url;
        try {
            url = new URL(request.getPostServer());
        }
        catch (MalformedURLException e1) {
            throw new SOAPException((Throwable)e1);
        }
        SOAPMessage soapMessage = this.createSoapMessage(request);
        SOAPMessage soapResponse = this.sendSoapMessage(soapMessage, url);
        Element OWSResponseRootElement = (Element)soapResponse.getSOAPBody().getChildElements().next();
        DOMHelper dom = new DOMHelper((Document)((Object)OWSResponseRootElement));
        OWSResponseReader reader = (OWSResponseReader)OGCRegistry.createReader((String)request.getService(), (String)request.getOperation(), (String)request.getVersion());
        try {
            response = reader.readXMLResponse(dom, OWSResponseRootElement);
        }
        catch (OWSException e) {
            throw new SOAPException((Throwable)e);
        }
        if (response instanceof ExecuteProcessResponse) {
            ((ExecuteProcessResponse)response).setDataStream((InputStream)soapResponse.getAttachments().next());
        }
        return response;
    }

    public SOAPMessage sendSoapMessage(SOAPMessage soapMessage, URL url) throws SOAPException {
        SOAPConnection soapConnection = this.soapConnectionFactory.createConnection();
        SOAPMessage soapResponse = soapConnection.call(soapMessage, (Object)url);
        return soapResponse;
    }

    public SOAPMessage createSoapMessage(DOMHelper dom) throws SOAPException {
        SOAPMessage soapMessage = this.soapMessageFactory.createMessage();
        soapMessage.getSOAPHeader().detachNode();
        soapMessage.getSOAPBody().addDocument(dom.getDocument());
        return soapMessage;
    }

    public SOAPMessage createSoapMessage(OWSRequest request) throws SOAPException {
        SOAPMessage soapMessage = this.soapMessageFactory.createMessage();
        soapMessage.getSOAPHeader().detachNode();
        OWSRequestWriter writer = (OWSRequestWriter)OGCRegistry.createWriter((String)request.getService(), (String)request.getOperation(), (String)request.getVersion());
        Element bodyElement = null;
        try {
            DOMHelper dom = new DOMHelper();
            bodyElement = writer.buildXMLQuery(dom, request);
        }
        catch (OWSException e) {
            throw new SOAPException((Throwable)e);
        }
        soapMessage.getSOAPBody().addDocument((Document)((Object)bodyElement));
        if (request instanceof ExecuteProcessRequest) {
            try {
                soapMessage = this.attachInputData((ExecuteProcessRequest)request, soapMessage);
            }
            catch (OWSException e) {
                throw new SOAPException((Throwable)e);
            }
            catch (IOException e) {
                throw new SOAPException((Throwable)e);
            }
        }
        return soapMessage;
    }

    public OWSRequest extractWPSRequest(InputStream inputStream) throws SOAPException, OWSException, CDMException {
        OWSRequest request = null;
        MimeHeaders header = null;
        try {
            SOAPMessage soapMessage = this.soapMessageFactory.createMessage(header, inputStream);
            String bodyContent = soapMessage.getSOAPBody().getTextContent();
            byte[] bytes = bodyContent.getBytes("UTF-8");
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            PostRequestFilter xmlRequest = new PostRequestFilter(new BufferedInputStream(input));
            DOMHelper dom = new DOMHelper((InputStream)xmlRequest, false);
            request = this.owsUtils.readXMLQuery(dom, dom.getBaseElement());
            if (request instanceof ExecuteProcessRequest) {
                AttachmentPart attachment = (AttachmentPart)soapMessage.getAttachments().next();
                ((ExecuteProcessRequest)request).setAttachmentPart(attachment);
            }
        }
        catch (DOMException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (DOMHelperException e) {
            throw new SOAPException((Throwable)e);
        }
        return request;
    }

    private SOAPMessage attachInputData(ExecuteProcessRequest request, SOAPMessage soapMessage) throws SOAPException, OWSException, IOException {
        AttachmentPart attachmentPart = soapMessage.createAttachmentPart();
        attachmentPart.setRawContent(ExecuteProcessRequestWriter.writeData(request), ExecuteProcessRequestWriter.getContentType(request));
        return soapMessage;
    }

    public void setSoapConnectionFactory(SOAPConnectionFactory soapConnectionFactory) {
        this.soapConnectionFactory = soapConnectionFactory;
    }

    public SOAPConnectionFactory getSoapConnectionFactory() {
        return this.soapConnectionFactory;
    }
}

