/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wrs;

import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.vast.ows.OWSLayerCapabilities;
import org.vast.ows.OWSRequest;
import org.vast.ows.OWSServiceCapabilities;
import org.vast.ows.OWSUtils;
import org.vast.ows.wrs.ServiceSearch;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExtrinsicObjectSearch
extends DOMHelper {
    protected static String Service;
    protected static String Keyword;
    protected static String LayerName;
    protected static float MinX;
    protected static float MinY;
    protected static float MaxX;
    protected static float MaxY;
    protected static String SRSNumber;
    protected static String Format;
    protected static String ServerURL;
    DOMHelper dom;
    ArrayList<String> serviceList;
    String sosVersion = "0.0.31";
    String wmsVersion = "1.1.1";
    String wfsVersion = "1.0.0";
    OWSUtils owsUtils = new OWSUtils();

    public ExtrinsicObjectSearch() {
        Keyword = "";
    }

    public ExtrinsicObjectSearch(String services, String name, String keyword, String nr, float minx, float miny, float maxx, float maxy, String format, String serverURL) {
        Service = services;
        LayerName = name;
        Keyword = keyword;
        SRSNumber = nr;
        MinX = minx;
        MinY = miny;
        MaxX = maxx;
        MaxY = maxy;
        Format = format;
        ServerURL = serverURL;
        this.serviceList = new ArrayList();
        this.serviceList.add("ObservationOffering");
        this.serviceList.add("WMS_Layer");
        this.serviceList.add("FeatureType");
    }

    public String CatalogRequest() {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GetRecords maxRecords=\"\" outputFormat=\"application/xml; \tcharset=UTF-8\" outputSchema=\"EBRIM\" version=\"2.0.0\" \txmlns=\"http://www.opengis.net/cat/csw\"> \t<Query typeNames=\"ExtrinsicObject\"> \t\t<ElementName>/ExtrinsicObject</ElementName> \t\t<Constraint version=\"1.0.0\"> \t\t\t<ogc:Filter xmlns:ebxml=\"urn:oasis:names:tc:ebxml-regrep:rim:xsd:2.5\" \t\t\t\txmlns:gml=\"http://www.opengis.net/gml\" \t\t\t\txmlns:ogc=\"http://www.opengis.net/ogc\" \t\t\t\txmlns:csw=\"http://www.opengis.net/csw\"> ";
        boolean addService = false;
        if (Service.trim().length() != 0) {
            addService = true;
            request = request + "<ogc:And> " + "\t<ogc:PropertyIsEqualTo> " + "\t\t<ogc:PropertyName>/ExtrinsicObject/@objectType</ogc:PropertyName> " + "\t\t<ogc:Literal>" + Service + "</ogc:Literal> " + "\t</ogc:PropertyIsEqualTo> ";
        }
        if (LayerName.trim().length() != 0 || Keyword.trim().length() != 0) {
            String variableName = LayerName;
            String variableKeyword = Keyword;
            if (LayerName.equalsIgnoreCase("")) {
                variableName = Keyword;
            }
            request = request + "<ogc:Or> " + "\t<ogc:PropertyIsLike escape=\"\\\" singleChar=\"_\" wildCard=\"%\"> " + "\t\t<ogc:PropertyName> " + "\t\t\t/ExtrinsicObject/Name/LocalizedString/@value " + "        </ogc:PropertyName> " + "\t\t<ogc:Literal>%" + variableName + "%</ogc:Literal> " + "\t</ogc:PropertyIsLike> " + "\t<ogc:PropertyIsLike escape=\"\\\" singleChar=\"_\" wildCard=\"%\"> " + "\t\t<ogc:PropertyName> " + "\t\t\t/ExtrinsicObject/Description/LocalizedString/@value " + "        </ogc:PropertyName> " + "\t<ogc:Literal>%" + variableKeyword + "%</ogc:Literal> " + "\t</ogc:PropertyIsLike> " + "\t<ogc:PropertyIsLike> " + "\t\t<ogc:Function name=\"CATALOG_TOOLS.SLOT_AS_STRING\"> " + "\t\t\t<ogc:PropertyName>/ExtrinsicObject/Slot/Phenomenas</ogc:PropertyName> " + "        </ogc:Function> " + "        <ogc:Literal>%" + variableKeyword + "%</ogc:Literal> " + "    </ogc:PropertyIsLike> " + "    <ogc:PropertyIsLike> " + "        <ogc:Function name=\"CATALOG_TOOLS.SLOT_AS_STRING\"> " + "            <ogc:PropertyName>/ExtrinsicObject/Slot/Identifier</ogc:PropertyName> " + "        </ogc:Function> " + "        <ogc:Literal>%" + variableKeyword + "%</ogc:Literal> " + "    </ogc:PropertyIsLike> " + "</ogc:Or> ";
        }
        if (MinX != -180.0f || MinY != -90.0f || MaxX != 180.0f || MaxY != 90.0f) {
            if (!addService) {
                request = request + "<ogc:And>";
            }
            request = request + "<ogc:Contains> " + "\t<ogc:PropertyName>/ExtrinsicObject/Slot/FootPrint</ogc:PropertyName>" + "\t<gml:Box srsName=\"EPSG:" + SRSNumber + "\"> " + "\t\t<gml:coordinates>" + MinX + "," + MinY + " " + MaxX + "," + MaxY + "</gml:coordinates> " + "    </gml:Box> " + "</ogc:Contains> ";
            if (!addService) {
                request = request + "</ogc:And>";
            }
        }
        if (addService) {
            request = request + "</ogc:And> ";
        }
        request = request + "            </ogc:Filter> " + "\t\t</Constraint> " + "\t</Query> " + "</GetRecords> ";
        return request;
    }

    public List<OWSLayerCapabilities> EOSSearch() {
        try {
            URL url = new URL(ServerURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "text/plain");
            PrintStream out = new PrintStream(connection.getOutputStream());
            String postRequest = this.CatalogRequest();
            out.print(postRequest);
            out.flush();
            connection.connect();
            out.close();
            InputStream in = connection.getInputStream();
            DOMHelper reader = new DOMHelper(in, false);
            String server = null;
            NodeList list = reader.getElements("SearchResults/ExtrinsicObject");
            ArrayList<OWSLayerCapabilities> layerCapAl = new ArrayList<OWSLayerCapabilities>();
            ArrayList<String> serverList = new ArrayList<String>();
            ArrayList<String> errorList = new ArrayList<String>();
            ArrayList<String> idList = this.createIDList(reader);
            for (int i = 0; i < list.getLength(); ++i) {
                String objectType = reader.getAttributeValue((Element)list.item(i), "objectType");
                if (this.serviceList.contains(objectType)) {
                    ServiceSearch search = new ServiceSearch(ServerURL, reader.getAttributeValue((Element)list.item(i), "id"));
                    server = search.getServer();
                }
                if (server == null || serverList.contains(server)) continue;
                if (errorList.contains(server) || !this.testServer(server)) {
                    errorList.add(server);
                    continue;
                }
                serverList.add(server);
                List<OWSLayerCapabilities> layerCapTmp = this.getEOSLayers(idList, server);
                layerCapAl.addAll(layerCapTmp);
            }
            ArrayList<OWSLayerCapabilities> layerCap = layerCapAl;
            return layerCap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected List<OWSLayerCapabilities> getEOSLayers(ArrayList<String> idList, String server) {
        server = OWSRequest.checkServer(server);
        OWSServiceCapabilities owsCap = null;
        try {
            int j;
            int i;
            String Version;
            if (Service.equalsIgnoreCase("ObservationOffering")) {
                Version = this.sosVersion;
                this.owsUtils.getCapabilities(server, "SOS", Version);
            }
            if (Service.equalsIgnoreCase("WMS_Layer")) {
                Version = this.wmsVersion;
                this.owsUtils.getCapabilities(server, "WCS", Version);
            }
            if (Service.equalsIgnoreCase("FeatureType")) {
                Version = this.wfsVersion;
                this.owsUtils.getCapabilities(server, "WFS", Version);
            }
            ArrayList<OWSLayerCapabilities> capList = new ArrayList<OWSLayerCapabilities>(idList.size());
            int capCount = 0;
            for (i = 0; i < owsCap.getLayers().size(); ++i) {
                if (owsCap.getLayers().get(i).getIdentifier() != null) continue;
                for (j = i; j < owsCap.getLayers().size() - 1; ++j) {
                    owsCap.getLayers().set(j, owsCap.getLayers().get(j + 1));
                }
            }
            for (i = 0; i < owsCap.getLayers().size() || capCount < capList.size(); ++i) {
                boolean found = false;
                for (j = 0; j < idList.size(); ++j) {
                    if (idList.get(j) == null || !owsCap.getLayers().get(i).getIdentifier().equalsIgnoreCase(idList.get(j).toString())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                capList.add(capCount, owsCap.getLayers().get(i));
                ++capCount;
            }
            owsCap.setLayers(capList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        List<OWSLayerCapabilities> capList = owsCap.getLayers();
        return capList;
    }

    protected ArrayList<String> createIDList(DOMHelper reader) {
        NodeList list = reader.getElements("SearchResults/ExtrinsicObject");
        ArrayList<String> idList = new ArrayList<String>();
        String id = null;
        for (int i = 0; i < list.getLength(); ++i) {
            int j;
            NodeList slotList = reader.getElements((Element)list.item(i), "Slot");
            if (Service.equalsIgnoreCase("ObservationOffering")) {
                for (j = 0; j < slotList.getLength(); ++j) {
                    if (!reader.getAttributeValue((Element)slotList.item(j), "name").equalsIgnoreCase("ObservationOfferingId")) continue;
                    id = reader.getElementValue((Element)slotList.item(j), "ValueList/Value");
                    break;
                }
            } else {
                for (j = 0; j < slotList.getLength(); ++j) {
                    if (!reader.getAttributeValue((Element)slotList.item(j), "name").equalsIgnoreCase("Identifier")) continue;
                    id = reader.getElementValue((Element)slotList.item(j), "ValueList/Value");
                    break;
                }
            }
            if (idList.contains(id)) continue;
            idList.add(id);
        }
        return idList;
    }

    public boolean testServer(String server) {
        try {
            System.out.print("Checking: ");
            if (Service.equalsIgnoreCase("ObservationOffering")) {
                this.owsUtils.getCapabilities(server, "SOS", this.sosVersion);
            } else if (Service.equalsIgnoreCase("WMS_Layer")) {
                this.owsUtils.getCapabilities(server, "WMS", this.wmsVersion);
            } else if (Service.equalsIgnoreCase("FeatureType")) {
                this.owsUtils.getCapabilities(server, "WFS", this.wfsVersion);
            }
        }
        catch (Exception e) {
            System.out.println("Error reading server: " + server);
            return false;
        }
        return true;
    }
}

