/*
 * Decompiled with CFR 0.152.
 */
package org.vast.ows.wrs;

import java.util.List;
import org.vast.ogc.OGCRegistry;
import org.vast.ows.AbstractRequestWriter;
import org.vast.ows.OWSException;
import org.vast.ows.wrs.WRSQuery;
import org.vast.util.Bbox;
import org.vast.xml.DOMHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WRSRequestWriter
extends AbstractRequestWriter<WRSQuery> {
    @Override
    public Element buildXMLQuery(DOMHelper domWriter, WRSQuery query) throws OWSException {
        Element rootElt = this.buildQueryRootElement(domWriter);
        List<WRSQuery.QueryType> queryTypes = query.getQueryTypeList();
        if (queryTypes.isEmpty()) {
            this.buildQueryAllSosElement(domWriter, rootElt);
            return rootElt;
        }
        if (queryTypes.contains((Object)WRSQuery.QueryType.SERVICE_SOS)) {
            this.buildServiceSearchElement(domWriter, rootElt, query.getServiceSearchId());
            return rootElt;
        }
        if (queryTypes.contains((Object)WRSQuery.QueryType.KEYWORD_SOS)) {
            this.buildQueryKeywordElement(domWriter, rootElt, query.getKeyword());
            return rootElt;
        }
        if (queryTypes.contains((Object)WRSQuery.QueryType.BBOX_SOS)) {
            this.buildQueryBboxElement(domWriter, rootElt, query.getBbox());
        }
        return rootElt;
    }

    protected Element buildQueryRootElement(DOMHelper domWriter) throws OWSException {
        domWriter.addUserPrefix("csw", OGCRegistry.getNamespaceURI((String)"CSW"));
        domWriter.addUserPrefix("ogc", OGCRegistry.getNamespaceURI((String)"OGC"));
        domWriter.addUserPrefix("gml", OGCRegistry.getNamespaceURI((String)"GML"));
        Element rootElt = domWriter.createElement("csw:GetRecords");
        domWriter.setAttributeValue(rootElt, "version", "2.0.0");
        domWriter.setAttributeValue(rootElt, "maxRecords", "80");
        domWriter.setAttributeValue(rootElt, "outputSchema", "EBRIM");
        return rootElt;
    }

    protected Element buildQueryAllSosElement(DOMHelper domWriter, Element rootElt) throws OWSException {
        Element queryElt = domWriter.addElement((Node)rootElt, "csw:Query");
        queryElt.setAttribute("typeNames", "Service Concept Classification");
        domWriter.setElementValue(queryElt, "csw:ElementName", "/Service");
        Element constraintElt = domWriter.addElement((Node)queryElt, "csw:Constraint");
        constraintElt.setAttribute("version", "1.0.0");
        Element filterElt = domWriter.addElement((Node)constraintElt, "ogc:Filter/ogc:And");
        this.addPropertyIsEqualToLiteral(domWriter, filterElt, "/Concept/Name/LocalizedString/@value", "SOS");
        this.addPropertyIsEqualToProperty(domWriter, filterElt, "/Concept/@id", "/Classification/@classificationNode");
        this.addPropertyIsEqualToProperty(domWriter, filterElt, "/Service/@id", "/Classification/@classifiedObject");
        return queryElt;
    }

    protected Element buildQueryBboxElement(DOMHelper domWriter, Element rootElt, Bbox bbox) throws OWSException {
        Element queryElt = domWriter.addElement((Node)rootElt, "csw:Query");
        queryElt.setAttribute("typeNames", "ExtrinsicObject");
        domWriter.setElementValue(queryElt, "csw:ElementName", "/ExtrinsicObject");
        Element constraintElt = domWriter.addElement((Node)queryElt, "csw:Constraint");
        constraintElt.setAttribute("version", "1.0.0");
        Element filterElt = domWriter.addElement((Node)constraintElt, "ogc:Filter/ogc:And");
        this.addPropertyIsEqualToLiteral(domWriter, filterElt, "/ExtrinsicObject/@objectType", "ObservationOffering");
        Element intersectsElt = domWriter.addElement((Node)filterElt, "ogc:Intersects");
        domWriter.setElementValue(intersectsElt, "ogc:PropertyName", "/ExtrinsicObject/Slot[@name=\"FootPrint\"]/ValueList/Value[1]");
        Element gmlBoxElt = domWriter.addElement((Node)intersectsElt, "gml:Box");
        gmlBoxElt.setAttribute("srsName", "EPSG:4326");
        String bboxStr = bbox.getMinX() + "," + bbox.getMinY() + " " + bbox.getMaxX() + "," + bbox.getMaxY();
        domWriter.setElementValue(gmlBoxElt, "gml:coordinates", bboxStr);
        return queryElt;
    }

    protected Element buildServiceSearchElement(DOMHelper domWriter, Element rootElt, String targetId) {
        Element targetElt = domWriter.addElement((Node)rootElt, "csw:Query");
        targetElt.setAttribute("typeNames", "Service Association");
        domWriter.setElementValue(targetElt, "csw:ElementName", "/Service");
        Element constraintElt = domWriter.addElement((Node)targetElt, "csw:Constraint");
        constraintElt.setAttribute("version", "1.0.0");
        Element filterElt = domWriter.addElement((Node)constraintElt, "ogc:Filter/ogc:And");
        this.addPropertyIsEqualToProperty(domWriter, filterElt, "/Association/@sourceObject", "/Service/@id");
        this.addPropertyIsEqualToLiteral(domWriter, filterElt, "/Association/@targetObject", targetId);
        return targetElt;
    }

    protected Element buildQueryKeywordElement(DOMHelper domWriter, Element rootElt, String keyword) throws OWSException {
        String kws = "%" + keyword + "%";
        Element queryElt = domWriter.addElement((Node)rootElt, "csw:Query");
        queryElt.setAttribute("typeNames", "ExtrinsicObject");
        domWriter.setElementValue(queryElt, "csw:ElementName", "/ExtrinsicObject");
        Element constraintElt = domWriter.addElement((Node)queryElt, "csw:Constraint");
        constraintElt.setAttribute("version", "1.0.0");
        Element filterElt = domWriter.addElement((Node)constraintElt, "ogc:Filter/ogc:And");
        this.addPropertyIsEqualToLiteral(domWriter, filterElt, "/ExtrinsicObject/@objectType", "ObservationOffering");
        Element orElt = domWriter.addElement((Node)filterElt, "ogc:Or");
        this.addPropertyIsLikeLiteral(domWriter, orElt, "/ExtrinsicObject/Name/LocalizedString/@value", kws);
        this.addPropertyIsLikeLiteral(domWriter, orElt, "/ExtrinsicObject/Description/LocalizedString/@value", kws);
        this.addPropertyIsLikeLiteral(domWriter, orElt, "/ExtrinsicObject/Slot[@name=\"ResultFormats\"]/ValueList/Value[1]", kws);
        this.addPropertyIsLikeLiteral(domWriter, orElt, "/ExtrinsicObject/Slot[@name=\"Procedures\"]/ValueList/Value[1]", kws);
        this.addPropertyIsLikeLiteral(domWriter, orElt, "/ExtrinsicObject/Slot[@name=\"ResultModels\"]/ValueList/Value[1]", kws);
        this.addPropertyIsLikeLiteral(domWriter, orElt, "/ExtrinsicObject/Slot[@name=\"ObservedProperties\"]/ValueList/Value[1]", kws);
        return queryElt;
    }

    protected Element addPropertyIsEqualToProperty(DOMHelper domWriter, Element parentElt, String propName, String targetProp) {
        Element propElt = domWriter.addElement((Node)parentElt, "+ogc:PropertyIsEqualTo");
        domWriter.setElementValue(propElt, "ogc:PropertyName", propName);
        domWriter.setElementValue(propElt, "+ogc:PropertyName", targetProp);
        return propElt;
    }

    protected Element addPropertyIsEqualToLiteral(DOMHelper domWriter, Element parentElt, String propName, String literal) {
        Element propElt = domWriter.addElement((Node)parentElt, "+ogc:PropertyIsEqualTo");
        domWriter.setElementValue(propElt, "ogc:PropertyName", propName);
        domWriter.setElementValue(propElt, "ogc:Literal", literal);
        return propElt;
    }

    protected Element addPropertyIsLikeLiteral(DOMHelper domWriter, Element parentElt, String propName, String literal) {
        Element propElt = domWriter.addElement((Node)parentElt, "+ogc:PropertyIsLike");
        domWriter.setElementValue(propElt, "ogc:PropertyName", propName);
        domWriter.setElementValue(propElt, "ogc:Literal", literal);
        return propElt;
    }

    @Override
    public String buildURLQuery(WRSQuery query) throws OWSException {
        return null;
    }
}

